
#ifndef IIRSCRAM_NEXT_STATEMENT_HH
#define IIRSCRAM_NEXT_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Umesh Kumar V. Rajasekaran 
//          Krishnan Subramani 
//          Narayanan Thondugulam 

#include "IIRBase_NextStatement.hh"

class IIR_List;
template <class type> class set;
class IIR_AboveAttribute;

class IIRScram_NextStatement : public IIRBase_NextStatement {
public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc( published_file &_cc_out );
  void _type_check();

  void _get_list_of_input_signals( set<IIR> * );
  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_NextStatement() {}
  virtual ~IIRScram_NextStatement() = 0;
    
private:
};
#endif
