// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Magnus Danielson    cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIRScram_IntegerLiteral.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "StandardPackage.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

using std::cerr;

IIRScram_IntegerTypeDefinition::~IIRScram_IntegerTypeDefinition() {}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_data_members( published_file &_cc_out ) {}

void
IIRScram_IntegerTypeDefinition::_publish_cc_temporary_type_info( published_file &_cc_out,
								 char *suffix, 
								 char *elementTypeInfo) {
  SCRAM_CC_REF( _cc_out, "IIRScram_IntegerTypeDefinition::_publish_cc_temporary_type_info");

  if (get_left() != NULL) {
    ASSERT ( get_left()  != NULL );
    ASSERT ( get_right() != NULL );
    
    _cc_out << "IntegerTypeInfo "
	    << OS("(");
    get_left()->_publish_cc_value( _cc_out );
    _cc_out << "," << NL();
    if(get_direction()->_is_ascending_range() == TRUE) {
      _cc_out << "ArrayInfo::to," << NL();
    }
    else {
      _cc_out << "ArrayInfo::downto," << NL();
    } 
    get_right()->_publish_cc_value( _cc_out );
    _cc_out << CS(")");
  }
  else if (_get_base_type() != NULL) {
    _get_base_type()->_publish_cc_temporary_type_info( _cc_out, suffix, elementTypeInfo );
  }
  else {
    cerr << "Error - IIRScram_IntegerTypeDefinition::_publish_cc_temporary_"
	 << "type_info(char*, char*) : Unable to determine range for publishing.\n";
    ASSERT ( FALSE );
  }
}

void
IIRScram_IntegerTypeDefinition::_publish_cc_type_info( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_IntegerTypeDefinition::_publish_cc_type_info" );
  if (_is_anonymous() == FALSE) {
    _cc_out << "IntegerTypeInfo ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info(";
    get_left()->_publish_cc_value( _cc_out );
    _cc_out << ", ";
    if(get_direction()->_is_ascending_range() == TRUE) {
      _cc_out << "ArrayInfo::to, ";
    }
    else {
      _cc_out << "ArrayInfo::downto, ";
    } 
    get_right()->_publish_cc_value( _cc_out );
    _cc_out << ")";
  }
}

void
IIRScram_IntegerTypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_IntegerTypeDefinition::_publish_cc_extern_type_info" );
  _cc_out << "extern IntegerTypeInfo ";
  
  if (_is_anonymous() == FALSE) {
    _publish_cc_lvalue( _cc_out );
  }
  else {
    ASSERT (_get_base_type() != NULL);
    _get_base_type()->_publish_cc_lvalue( _cc_out );
  }
  
  _cc_out << "_info;\n";
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_type_string( published_file &_cc_out ){
  _cc_out << "IntegerType";
}


void
IIRScram_IntegerTypeDefinition::_publish_cc_decl_cc( published_file &_cc_out ) {
  _publish_cc_define_type_attributes( _cc_out );
}


void 
IIRScram_IntegerTypeDefinition::_publish_cc_left( published_file &_cc_out ) {
  get_left()->_publish_cc_lvalue( _cc_out );
}


void 
IIRScram_IntegerTypeDefinition::_publish_cc_right( published_file &_cc_out ) {
  get_right()->_publish_cc_lvalue( _cc_out );
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_universal_type( published_file &_cc_out ) {
  _cc_out << "UniversalInteger";
}

const string
IIRScram_IntegerTypeDefinition::_get_cc_kernel_type(){
  return "IntegerType";
}

IIR_TypeDefinition *
IIRScram_IntegerTypeDefinition::_check_special_compatible( IIR_TypeDefinition *to_check ){
  // Note that it things like array indexes can be subtypes of universal
  // integer so we'll cut to the chase and simply check base types.
  if( to_check->_get_bottom_base_type() == 
      StandardPackage::get_savant_universal_integer()->_get_bottom_base_type() ||
      ( _get_bottom_base_type() == 
	StandardPackage::get_savant_universal_integer()->_get_bottom_base_type()
	&& to_check->_is_integer_type() == TRUE ) ){
    return StandardPackage::get_savant_universal_integer();
  }
  else{
    return NULL;
  }
}
  
IIR_TypeDefinition *
IIRScram_IntegerTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_IntegerSubtypeDefinition();
  copy_location( this, retval );
  return retval;
}


void 
IIRScram_IntegerTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  char *multiplying_operators[] = {"\"*\"", "\"/\"", "\"mod\"", "\"rem\"", NULL };
  IIR_ScalarTypeDefinition::_build_implicit_operators( add_to );
  IIR_TypeDefinition::_build_implicit_operators( multiplying_operators,
						 add_to,
						 this,
						 this,
						 this );

  IIR_TypeDefinition *integer_type = StandardPackage::get_integer_type();
  IIR_TypeDefinition::_build_implicit_operator( "\"**\"", add_to, this, this, integer_type );  
}

void 
IIRScram_IntegerTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_IntegerTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with an integer type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}


IIR_IntegerSubtypeDefinition *
IIRScram_IntegerTypeDefinition::_construct_new_type( IIR_RangeTypeDefinition *init_info,
						     IIR_TypeDeclaration *type_decl ){
  IIR_IntegerSubtypeDefinition *retval = new IIR_IntegerSubtypeDefinition();
  IIR_IntegerTypeDefinition *base_type = new IIR_IntegerTypeDefinition();

  _init_scalar_type( init_info, base_type, retval, type_decl );

  return retval;
}


visitor_return_type *
IIRScram_IntegerTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_IntegerTypeDefinition(this, arg);
};
