// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ececs.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_FileDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_SimpleName.hh"
#include "IIR_Identifier.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_Attribute.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_Label.hh"
#include "symbol_table.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


extern symbol_table* cgen_sym_tab_ptr;

IIRScram_FileDeclaration::~IIRScram_FileDeclaration() {}


void 
IIRScram_FileDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "file ";
  _publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);

  if (get_file_open_expression() != NULL) {
    _vhdl_out << " open ";
    get_file_open_expression()->_publish_vhdl(_vhdl_out);
  }
  
  if (get_file_logical_name() != NULL) {
    _vhdl_out << " is ";
    get_file_logical_name()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << ";\n";
}

void 
IIRScram_FileDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_FileDeclaration::_publish_cc" );

  ASSERT (cgen_sym_tab_ptr != NULL);

  if( (!cgen_sym_tab_ptr->in_scope(this)) &&
      _get_declarative_region()->get_kind() != IIR_PACKAGE_DECLARATION &&
      _get_declarative_region()->get_kind() != IIR_PACKAGE_BODY_DECLARATION &&
      _get_declarative_region()->get_kind() != IIR_ARCHITECTURE_DECLARATION ){
    cgen_sym_tab_ptr->add_declaration( this );
  }

  if (((_get_declarative_region()->get_kind() == IIR_ARCHITECTURE_DECLARATION) ||
       (_get_declarative_region()->_is_iir_concurrent_statement() ==  TRUE)) &&
      (_get_declarative_region()->get_kind() != IIR_PROCESS_STATEMENT)) {
    ostringstream prefix;
    IIR_ProcessStatement* process_ptr = _get_current_process_statement();
    // Need a different scope for getting files in architectures and blocks etc..
    if( _get_currently_publishing_unit() == PROCESS ){
      prefix << "(("
	     << process_ptr->_get_enclosing_scope()->_get_cc_elaboration_class_name()
	     << " *) getProc())->";
    }
    else {
      prefix << "((" << *process_ptr->_get_label() << " *) processPtr)->";
    }
    
    process_ptr->_publish_cc_scoping_prefix( prefix, _get_declarative_region(), process_ptr );
    _set_publish_prefix_string(prefix.str());
  }
  else {
    _set_scoping_prefix();
  }
  
  ASSERT(get_file_logical_name() != NULL);

  // Ditto, this breaks process statements
  if (//(_get_declarative_region()->_is_iir_concurrent_statement() == FALSE) &&
      (_get_declarative_region()->get_kind() != IIR_PACKAGE_DECLARATION) &&
      (_get_declarative_region()->get_kind() != IIR_PACKAGE_BODY_DECLARATION)) {
    _publish_cc_prefix_string( _cc_out );
  }
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  // _cc_out << "_" << this;

  _reset_scoping_prefix();
}

void
IIRScram_FileDeclaration::_publish_cc_decl( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_FileDeclaration::_publish_cc_decl" );

  _cc_out << get_subtype()->_get_cc_type_name();
  _cc_out << " ";
  _get_declarator()->_publish_cc_lvalue( _cc_out );

  if (_is_currently_publishing_subprogram() == TRUE) {
    _cc_out << "(processPtr, ";
    get_file_logical_name()->_publish_cc_lvalue( _cc_out );
    _cc_out << ", _savant_file_open_kind(";

    IIR_SimpleName *expr = (IIR_SimpleName*)get_file_open_expression();
    
    if (!IIR_Identifier::_cmp((IIR_Identifier*)(expr->get_prefix()), "read_mode")) {
      _cc_out << "_savant_file_open_kind::READ_MODE";
    }
    else if (!IIR_Identifier::_cmp((IIR_Identifier*)(expr->get_prefix()), "write_mode")){
      _cc_out << "_savant_file_open_kind::WRITE_MODE";
    }
    else {
      _cc_out << "_savant_file_open_kind::APPEND_MODE";
    }
    
    _cc_out << "))";
  }
  
  _cc_out << ";\n";
}

void
IIRScram_FileDeclaration::_publish_cc_shared_file_decl( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_FileDeclaration::_publish_cc_shared_file_decl" );

  if ((_get_declarative_region()->_is_iir_package_declaration() == TRUE) ||
      (_get_declarative_region()->_is_iir_package_body_declaration() == TRUE)) {
    _cc_out << "SharedFileType* ";
  }
  
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  _cc_out << " = new SharedFileType(";
  get_file_logical_name()->_publish_cc_lvalue( _cc_out );
  _cc_out << ", _savant_file_open_kind(";
  
  IIR_SimpleName *expr = (IIR_SimpleName*)get_file_open_expression();
    
  if (!IIR_Identifier::_cmp((IIR_Identifier*)(expr->get_prefix()), "read_mode")) {
    _cc_out << "_savant_file_open_kind::READ_MODE";
  }
  else if (!IIR_Identifier::_cmp((IIR_Identifier*)(expr->get_prefix()), "write_mode")){
    _cc_out << "_savant_file_open_kind::WRITE_MODE";
  }
  else {
    _cc_out << "_savant_file_open_kind::APPEND_MODE";
  }
  
  _cc_out << "));\n";
}

IIR_Boolean
IIRScram_FileDeclaration::_is_read_file() {
  ASSERT(get_file_open_expression()->get_kind() == IIR_SIMPLE_NAME);

  IIR_SimpleName* expr = (IIR_SimpleName*)get_file_open_expression();

  if (!IIR_Identifier::_cmp((IIR_Identifier*)expr->get_prefix(), "read_mode")){
    return true;
  }
  else {
    return false;
  }
}

IIR_Boolean
IIRScram_FileDeclaration::_is_write_file() {
  ASSERT(get_file_open_expression()->get_kind() == IIR_SIMPLE_NAME);

  IIR_SimpleName* expr = (IIR_SimpleName*)get_file_open_expression();

  if (!IIR_Identifier::_cmp((IIR_Identifier*)expr->get_prefix(),"write_mode")||
     !IIR_Identifier::_cmp((IIR_Identifier*)expr->get_prefix(),"append_mode")){
    return true;
  }
  else {
    return false;
  }
}

IIR_Boolean
IIRScram_FileDeclaration::_is_shared_file() {
  ASSERT (_get_declarative_region() != NULL);
  IIR *declRegn = _get_declarative_region();

  if ((declRegn->_is_iir_package_declaration() == TRUE) ||
      (declRegn->_is_iir_package_body_declaration() == TRUE) ||
      (declRegn->get_kind() == IIR_ARCHITECTURE_DECLARATION)  ||
      (declRegn->_is_iir_concurrent_statement() == TRUE)) {
    return TRUE;
  }

  return  FALSE;
}

IIRScram_Declaration::declaration_type 
IIRScram_FileDeclaration::_get_type() {
  return S_FILE;
}

IIR*
IIRScram_FileDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_FileDeclaration();
    IIRScram_ObjectDeclaration::_clone(_my_clone);

    _my_clone->set_file_open_expression(get_file_open_expression());
    _my_clone->set_file_logical_name(get_file_logical_name());
  }
  return _my_clone;
}

visitor_return_type *IIRScram_FileDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_FileDeclaration(this, arg);
};
