// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_DelayedAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "error_func.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "sstream-wrap.hh"

IIRScram_DelayedAttribute::~IIRScram_DelayedAttribute() {}


void 
IIRScram_DelayedAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'DELAYED";

  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ") ";
  }
}


IIR_TextLiteral *
IIRScram_DelayedAttribute::_build_attribute_name() {
  char *name = "delayed";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_DelayedAttribute::get_subtype(){
  return _get_prefix_subtype( &IIR::_is_signal );
}


IIR_Declaration *
IIRScram_DelayedAttribute::_get_implicit_declaration( const string &name, 
						      IIR_TypeDefinition *type ){
  return _build_signal_declaration( name, type );
}

void  
IIRScram_DelayedAttribute::_resolve_suffix_special(){
  _resolve_suffix_non_negative_time();
}

visitor_return_type *IIRScram_DelayedAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_DelayedAttribute(this, arg);
};
