
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Narayanan Thondugulam
//          Timothy J. McBrayer 
//	    Magnus Danielson	cfmd@swipnet.se

#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

IIRScram_ConstantInterfaceDeclaration::~IIRScram_ConstantInterfaceDeclaration(){}

void 
IIRScram_ConstantInterfaceDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  //  ASSERT(get_mode() == IIR_IN_MODE);
  ASSERT(get_declarator()->get_kind() == IIR_IDENTIFIER);
  
  _vhdl_out << "constant ";
  _publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_mode(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_decl( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc_decl" );

  ASSERT(get_mode() == IIR_IN_MODE);

  _cc_out << get_subtype()->_get_cc_type_name();
  _cc_out << " ";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  _cc_out << " = ";
  if (get_value() != NULL) {
    get_value()->_publish_cc_lvalue( _cc_out );
  } 
  else {
    get_subtype()->_publish_cc_init_val( _cc_out );
  }
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc_elaborate" );

  if(_get_currently_publishing_unit() == IIRScram::ENTITY_DECL) {
    get_subtype()->_publish_cc_include( _cc_out );
    _cc_out << "extern ";
  }
  _publish_cc_type_and_object_name( _cc_out );
  _cc_out << "_info";
  _cc_out.end_statement();
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_elaborate_as_pointers( published_file &_cc_out,
									  IIR_Boolean publishDefinition) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc_elaborate_as_pointers" );
  
  if (publishDefinition == FALSE) {
    _cc_out << "  extern ";
  }
  
  get_subtype()->_publish_cc_elaborate( _cc_out );
  _cc_out << "* ";
  _get_declarator()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_info;\n" << NL();
}

IIRScram_Declaration::declaration_type 
IIRScram_ConstantInterfaceDeclaration::_get_type() {
  return INTERFACE_CONSTANT;
}

void 
IIRScram_ConstantInterfaceDeclaration::_publish_cc_universal_value( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc_universal_value" );
  _publish_cc_rvalue( _cc_out );
  _cc_out << ".readVal()";
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc" );

  ASSERT(get_declarator()->get_kind() == IIR_IDENTIFIER);
  
  if(_is_currently_publishing_subprogram() == TRUE) {
    if ((_get_declarative_region() != NULL) &&
	(_get_declarative_region()->get_kind() == IIR_ENTITY_DECLARATION)) {
      _cc_out << "*";
      _get_declarator()->_publish_cc_lvalue( _cc_out );
      _cc_out << "_info";
    }
    else {
      _get_declarator()->_publish_cc_lvalue( _cc_out );
    }
  }
  else {
    if ((_get_currently_publishing_unit() == PROCESS_STATE) || 
	(_get_currently_publishing_unit() == PROCESS) || 
	(_get_currently_publishing_unit() == IIRScram::TYPE) ||
	(_get_currently_publishing_unit() == ENTITY_DECL)) {
      _cc_out << "(*";
      
    }
    else {
      _publish_cc_prefix_string( _cc_out );
    }
    
    
    _get_declarator()->_publish_cc_elaborate( _cc_out );
    _cc_out << "_info";
    
    if ((_get_currently_publishing_unit() == PROCESS_STATE) || 
	(_get_currently_publishing_unit() == PROCESS) || 
	(_get_currently_publishing_unit() == IIRScram::TYPE) ||
	(_get_currently_publishing_unit() == ENTITY_DECL)) {
      _cc_out << ")";
    }
  }
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_headers( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc_headers" );

  IIRScram_ObjectDeclaration::_publish_cc_headers( _cc_out );
  if (_get_currently_publishing_unit() == IIRScram::TYPE) {
    if (_get_declarative_region()->get_kind() == IIR_ENTITY_DECLARATION) {
      _get_declarative_region()->_publish_cc_include_decls( _cc_out );
    }
  }
}

const string
IIRScram_ConstantInterfaceDeclaration::_get_cc_object_type() {
  return "VARIABLE";
}

const string
IIRScram_ConstantInterfaceDeclaration::_get_cc_kernel_type(){
  //  SCRAM_CC_REF( _cc_out, "IIRScram_ConstantInterfaceDeclaration::_publish_cc_kernel_type" );
  ASSERT ( get_subtype() != NULL );
  return get_subtype()->_get_cc_kernel_type();
}

IIR *
IIRScram_ConstantInterfaceDeclaration::_clone() {
  return this;
}

void 
IIRScram_ConstantInterfaceDeclaration::_type_check( IIRScram_InterfaceDeclaration::_InterfaceListType ){
  if( get_subtype()->_is_access_type() == TRUE || get_subtype()->_is_file_type() == TRUE ){
    ostringstream err;
    err << "Constant interface declaration |" << *get_declarator() << "| must have a subtype "
	<< "indication that defines a subtype that is neither an access type or a file type.";
    report_error( this, err.str() );
  }
  
  IIR_InterfaceDeclaration::_type_check();
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_ams_function(published_file &_cc_out) {
  
  if (_get_currently_publishing_unit() == SIMULTANEOUS_IF) {
    _get_declarator()->_publish_cc_lvalue(_cc_out);
  }
  else {
    if (_get_currently_publishing_unit() == IIRScram::ARCHITECTURE_DECL || 
        _get_currently_publishing_unit() == IIRScram::SIMULTANEOUS_STATEMENT) {
      _cc_out << "new equationNode('N', ((";
      get_subtype()->_publish_cc_universal_type(_cc_out);
      _cc_out << "*)&(";
      _get_declarator()->_publish_cc_lvalue(_cc_out);
      _cc_out << ".getVHDLData()))->val, node" 
              << (int)(_stmt_node_index/2) << ");" << NL();
    }
    else {
      get_value()->_publish_cc_value(_cc_out);
    }
  }
}

visitor_return_type *IIRScram_ConstantInterfaceDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConstantInterfaceDeclaration(this, arg);
};

void
IIRScram_ConstantInterfaceDeclaration::_build_generic_parameter_set(set<IIR_Declaration> *to_build) {
  to_build->add(this);
}

void
IIRScram_ConstantInterfaceDeclaration::_set_stmt_node_index(IIR_Int32 *index, bool _is_right_child, bool &reducibleFlag) {
  if (_is_right_child == true) {
   _stmt_node_index = 2 * (*index)+ 1;
  }
  else {
   _stmt_node_index = 2 * (*index);
  }
}
