// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_ConditionalWaveform.hh"
#include "IIR_WaveformElement.hh"
#include "resolution_func.hh"
#include "set.hh"
#include <iostream>
#include "IIR_WaveformList.hh"
#include "StandardPackage.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"

IIRScram_ConditionalWaveform::~IIRScram_ConditionalWaveform(){}

void 
IIRScram_ConditionalWaveform::_publish_vhdl(ostream &_vhdl_out) {
  waveform._publish_vhdl(_vhdl_out);
  if(get_condition() != NULL) {
    _vhdl_out << " when ";
    get_condition()->_publish_vhdl(_vhdl_out);
  }
}


set<IIR_TypeDefinition> *
IIRScram_ConditionalWaveform::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  return waveform.first()->_get_rval_set(constraint_function);
}


IIR *
IIRScram_ConditionalWaveform::_semantic_transform( set<IIR_TypeDefinition> *my_rvals ){
  IIR_WaveformElement *current_waveform;
  current_waveform = waveform.first();
  while( current_waveform != NULL ){
    IIR *temp_waveform = current_waveform->_semantic_transform( my_rvals );
    waveform._replace( current_waveform, temp_waveform );		       
    current_waveform = waveform.successor( (IIR_WaveformElement *)
					   temp_waveform );
  }

  return this;
}


IIR *
IIRScram_ConditionalWaveform::_rval_to_decl( IIR_TypeDefinition *my_type ){
  IIR_WaveformElement *current_waveform;
  current_waveform = waveform.first();
  while( current_waveform != NULL ){
    IIR *temp_waveform = current_waveform->_rval_to_decl( my_type );
    waveform._replace( current_waveform, temp_waveform );		       
    current_waveform = waveform.successor( (IIR_WaveformElement *)
					   temp_waveform );
  }
  return this;
}

void 
IIRScram_ConditionalWaveform::_type_check( set<IIR_TypeDefinition> *my_type ){
  IIR_TypeDefinition *bool_rval = StandardPackage::get_boolean_type();

  set<IIR_TypeDefinition> temp_set( bool_rval );

  if( get_condition() != NULL ){
    set_condition( get_condition()->_semantic_transform( &temp_set ));
    get_condition()->_type_check( &temp_set );
    set_condition( get_condition()->_rval_to_decl( bool_rval ) );
  }

  IIR_WaveformElement *current_waveform;
  current_waveform = waveform.first();
  while( current_waveform != NULL ){
    current_waveform->_type_check( my_type );
    current_waveform = waveform.successor( current_waveform );
  }
}

ostream &
IIRScram_ConditionalWaveform::_print( ostream &os ){
  os << waveform;

  if( get_condition() != NULL ){
    os << "when ";
    os << *get_condition();
  }

  return os;
}

IIR_Boolean 
IIRScram_ConditionalWaveform::_is_resolved(){
  IIR_Boolean retval = TRUE;

  if( get_condition() != NULL && get_condition()->_is_resolved() == FALSE ){
    retval = FALSE;
  }
  else if( waveform._is_resolved() == FALSE ){
    retval = FALSE;
  }

  return retval;
}

void
IIRScram_ConditionalWaveform::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  if(get_condition() != NULL) {
    get_condition()->_build_sensitivity_list(sensitivity_list);
  }
  waveform._build_sensitivity_list(sensitivity_list);
}

visitor_return_type *IIRScram_ConditionalWaveform::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConditionalWaveform(this, arg);
};
