
#ifndef IIRSCRAM_COMPONENT_CONFIGURATION_HH
#define IIRSCRAM_COMPONENT_CONFIGURATION_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ComponentConfiguration.hh"

class IIR_List;

class IIRScram_ComponentConfiguration : public IIRBase_ComponentConfiguration {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);


  void _publish_vhdl(ostream &);

  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_configure_block( published_file &_cc_out, IIR_Boolean = FALSE );

  void _type_check_configuration_item( IIR_List &, IIR * );

  IIR *_get_component_name( );
  void _set_component_name( IIR * );
  IIR_LibraryUnit *_get_entity_aspect();

  IIR_Boolean _is_resolved();

protected:
  
  IIRScram_ComponentConfiguration() {};
  virtual ~IIRScram_ComponentConfiguration() = 0;
    
private:
  

};

#endif
