
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_ComponentConfiguration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_LibraryUnit.hh"
#include "IIR_Name.hh"
#include "IIR_LibraryUnitList.hh"
#include "IIR_BlockConfiguration.hh"
#include "IIR_AssociationList.hh"
#include "IIR_AssociationElement.hh"
#include "IIR_Designator.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_Label.hh"
#include "IIR_Statement.hh"
#include "IIR_ConfigurationDeclaration.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "error_func.hh"
#include "published_file.hh"
#include "symbol_table.hh"
#include "sstream-wrap.hh"


IIRScram_ComponentConfiguration::~IIRScram_ComponentConfiguration(){}

void 
IIRScram_ComponentConfiguration::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_component_name()->_is_resolved() == TRUE);
  _vhdl_out << " for ";
  instantiation_list._publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_component_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "\n";
  if(get_entity_aspect() != NULL) {
    _vhdl_out << " use ";
    get_entity_aspect()->_publish_vhdl_with_library_name(_vhdl_out);
  }
  if(generic_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n generic map ( ";
    generic_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
  if(port_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n port map ( ";
    port_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
  
  if ( get_entity_aspect() != NULL || generic_map_aspect.num_elements() > 0 || port_map_aspect.num_elements() > 0 ){
    _vhdl_out << ";\n";
  }
  if ( get_block_configuration() != NULL ){
    get_block_configuration()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << "end for;\n";  
}

void
IIRScram_ComponentConfiguration::_publish_cc_headers( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_ComponentConfiguration::_publish_cc_headers" );

  ASSERT( get_component_name() != NULL );
  get_component_name()->_publish_cc_include( _cc_out );
  if(get_entity_aspect() != NULL) {
    get_entity_aspect()->_publish_cc_include_elab( _cc_out );
  }
  if ( get_block_configuration() != NULL ){
    get_block_configuration()->_publish_cc_headers( _cc_out );
  }
}


void
IIRScram_ComponentConfiguration::_publish_cc_configure_block( published_file &_cc_out,
							      IIR_Boolean _is_within_generate_for){

  string scratch1_ptr;
  string scratch2_ptr;
  string referenceStr;
  
  IIR_Designator* designator = instantiation_list.first();

  SCRAM_CC_REF( _cc_out, "IIRScram_ComponentConfiguration::_publish_cc_configure_block" );

  while(designator != NULL) { 
    ostringstream scratch1;
    ostringstream scratch2;
    if( designator->get_kind() != IIR_DESIGNATOR_EXPLICIT ){
      ostringstream err;
      err << designator->get_kind_text() << " not yet handled.";
      report_error( designator, err.str() );
      abort();
    }

    ASSERT(designator->get_kind() == IIR_DESIGNATOR_EXPLICIT);
    ASSERT(designator->_get_name()->get_kind() == IIR_LABEL);
    IIR_Label* label = (IIR_Label*)designator->_get_name();
    ASSERT(label->_is_resolved() == TRUE);
    scratch1 << "enclosingArch->";
    if(label->get_statement() == NULL) {
      scratch1 << *label->_get_declarator();
    }
    else {
      scratch1 << *label->get_statement()->_get_label()->_get_declarator();
    }
    scratch1 << "_elab_obj";

    if (_is_within_generate_for == TRUE) {
      scratch1 << "[generateConstant]";
      referenceStr = ".";
    }
    else {
      referenceStr = "->";
    }
      
    scratch1_ptr = scratch1.str();

    scratch2 << "enclosingArch1->";
    if(label->get_statement() == NULL) {
      scratch2 << *label->_get_declarator();
    }
    else {
      scratch2 << label->get_statement()->_get_label()->_get_declarator();
    }
    scratch2 << "_elab_obj";
    if (_is_within_generate_for == TRUE) {
      scratch2 << "[generateConstant]";
    }
    scratch2_ptr = scratch2.str();

    ASSERT(get_component_name()->_is_resolved() == TRUE);

    if(get_entity_aspect() != NULL) {
      _cc_out << "if(" << scratch1_ptr << referenceStr
	      << "boundedEntity != NULL) {\n"
	      << " delete " << scratch1_ptr << referenceStr
	      << "boundedEntity;\n" 
	      << "}\n"
	      << scratch1_ptr << referenceStr << "boundedEntity = "
	      << " new " << get_entity_aspect()->_get_cc_elaboration_class_name() << "(\n";
      if( generic_map_aspect.num_elements() > 0 ){
	IIR* tempNode = _get_current_publish_node();
	_set_current_publish_node( designator->_get_name() );
	generic_map_aspect._publish_cc_generic_map_aspect( _cc_out );
	_set_current_publish_node( tempNode );
      }
      _cc_out << ");\n";
      if(port_map_aspect.num_elements() > 0) {
	_cc_out << "{\n"
		<< get_component_name()->_get_cc_elaboration_class_name()
		<< " *component = ";
	if (_is_within_generate_for == TRUE)  {
	  _cc_out << "&";
	}
	
	_cc_out << scratch1_ptr << ";\n";
	if(get_entity_aspect()->get_kind() == IIR_CONFIGURATION_DECLARATION) {
	  IIR_ConfigurationDeclaration* config_decl = (IIR_ConfigurationDeclaration*)get_entity_aspect();
	  _cc_out << config_decl->_get_configured_architecture()->_get_cc_elaboration_class_name()
		  << "* architecture = (("
		  << config_decl->_get_configured_architecture()->_get_cc_elaboration_class_name()
		  << " *)(( " << get_entity_aspect()->_get_cc_elaboration_class_name()
		  << " *)"
		  << "component->boundedEntity)->configuredEntity);\n";
	}
	else {
	  _cc_out << get_entity_aspect()->_get_cc_elaboration_class_name()
		  << "* architecture = ("
		  <<  get_entity_aspect()->_get_cc_elaboration_class_name()
		  << " *) component->boundedEntity;\n";
	}
	_cc_out << "PortMap* tmpPortMap = &(architecture->portMapAspect);\n";
	port_map_aspect._publish_cc_port_map_associations( _cc_out );
	_cc_out << "};\n";
      }
    }
    if ( get_block_configuration() != NULL ){
      _cc_out << get_entity_aspect()->_get_cc_elaboration_class_name()
	      << "* enclosingArch = ("
	      << get_entity_aspect()->_get_cc_elaboration_class_name()
	      << " *)" << scratch2_ptr << "->boundedEntity;\n"
	      << get_entity_aspect()->_get_cc_elaboration_class_name()
	      << "* enclosingArch1 = enclosingArch;\n"
	      << "{\n";
      get_block_configuration()->_publish_cc_configure_block( _cc_out );
      _cc_out << "};\n";
    }
    designator = instantiation_list.successor(designator);
  }
}

void
IIRScram_ComponentConfiguration::_type_check_configuration_item( IIR_List &statement_list,
								 IIR *enclosing_region ){
  ASSERT( enclosing_region != NULL );
  ASSERT( enclosing_region->get_kind() == IIR_BLOCK_CONFIGURATION );
  IIR_BlockConfiguration *enclosing_config = (IIR_BlockConfiguration *)enclosing_region;

  ASSERT( enclosing_config->get_block_specification() != NULL );
  _type_check_configuration( port_map_aspect, generic_map_aspect, 
			     IIRScram_ConfigurationSpecification::CONFIG_SPEC );
  
  if( get_block_configuration() != NULL ){
    get_block_configuration()->_type_check_configuration_item( statement_list, this );
  }

  instantiation_list._type_check_as_instantiation_list( get_component_name(), 
							statement_list,
							this );
}

IIR *
IIRScram_ComponentConfiguration::_get_component_name( ){
  return get_component_name();
}

void 
IIRScram_ComponentConfiguration::_set_component_name( IIR *name ){
  set_component_name( name );
}

IIR_LibraryUnit *
IIRScram_ComponentConfiguration::_get_entity_aspect(){
  return get_entity_aspect();
}

IIR_Boolean 
IIRScram_ComponentConfiguration::_is_resolved(){
  IIR_Boolean retval = TRUE;
  if( (get_component_name() != NULL && get_component_name()->_is_resolved() == FALSE) ||
      (get_entity_aspect() != NULL && get_entity_aspect()->_is_resolved() == FALSE) ||
      (get_block_configuration() != NULL && get_block_configuration()->_is_resolved() == FALSE) ||
      instantiation_list._is_resolved() == FALSE ||
      generic_map_aspect._is_resolved() == FALSE ||
      port_map_aspect._is_resolved() == FALSE ){
    retval = FALSE;
  }
  return retval;
}


visitor_return_type *IIRScram_ComponentConfiguration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ComponentConfiguration(this, arg);
};

