
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_AcrossAttribute.hh"
#include "IIR_Identifier.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "StandardPackage.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_NatureDeclaration.hh"
#include "IIR_NatureDefinition.hh"
#include "IIR_ScalarNatureDefinition.hh"
#include "error_func.hh"
#include "IIR_Declaration.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

using std::cerr;
using std::endl;

IIRScram_AcrossAttribute::~IIRScram_AcrossAttribute() {}

void
IIRScram_AcrossAttribute::_publish_vhdl(ostream &_vhdl_out) {
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'ACROSS " ;
}

IIR_TypeDefinition*
IIRScram_AcrossAttribute::get_subtype() {
  set<IIR_Declaration>* nature_decl_set;
  IIR_Declaration* nature_decl;
  IIR_TypeDefinition *type_def;
  
  nature_decl_set = get_prefix()->_symbol_lookup();
  if (nature_decl_set->num_elements() == 0) {
    return NULL;
  }
  nature_decl = nature_decl_set->get_element();
  if (nature_decl->get_kind() == IIR_NATURE_DECLARATION) {
    type_def =((IIR_ScalarNatureDefinition*)
               ((IIR_NatureDeclaration*)nature_decl)->get_nature())->get_across();
    if (type_def != NULL) {
      return type_def;
    }
    else {
      cerr <<"Invalid Across type for Nature "<<endl;
      return NULL;
    }
  }
  else {
    cerr << " |" << *_get_attribute_name()
         << "| - may only be applied to natures " << endl;
    return NULL;
  }
}

IIR_TextLiteral *
IIRScram_AcrossAttribute::_build_attribute_name(){
  char *name = "across";
  return IIR_Identifier::get( name, strlen(name) );
}
