/* Copyright (C) 1999-2004
 * Smithsonian Astrophysical Observatory, Cambridge, MA, USA
 * For conditions of distribution and use, see copyright notice in "copyright"
 */

%option noyywrap
%option caseless
%option never-interactive
%option c++

%{
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <ctype.h>

  #include "util.h"
  #include "parser.H"

  extern frFlexLexer* frlexx;
  extern int frsign;
%}

D   [0-9]
E   [Ee][+-]?{D}+

/* rules */

%%

about		{return ABOUT_;}
alloc		{return ALLOC_;}
allocgz		{return ALLOCGZ_;}
align		{return ALIGN_;}
all		{return ALL_;}
amplifier	{return AMPLIFIER_;}
analysis	{return ANALYSIS_;}
angle		{return ANGLE_;}
annulus		{return ANNULUS_;}
append		{return APPEND_;}
arcmin		{return ARCMIN_;}
arcsec		{return ARCSEC_;}
area		{return AREA_;}
array		{return ARRAY_;}
arrow		{return ARROW_;}
ast		{return AST_;}
auto		{return AUTO_;}
average		{return AVERAGE_;}
b1950		{return B1950_;}
back		{return BACK_;}
base		{return BASE_;}
bbox		{return BBOX_;}
begin		{return BEGIN_;}
bg		{return BG_;}
bin		{return BIN_;}
bitpix		{return BITPIX_;}
block		{return BLOCK_;}
box		{return BOX_;}
boxcar		{return BOXCAR_;}
boxcircle	{return BOXCIRCLE_;}
buffer		{return BUFFER_;}
bw		{return BW_;}
callback	{return CALLBACK_;}
canvas		{return CANVAS_;}
center		{return CENTER_;}
channel		{return CHANNEL_;}
ciao		{return CIAO_;}
circle		{return CIRCLE_;}
clear		{return CLEAR_;}
click		{return CLICK_;}
clip		{return CLIP_;}
colormap	{return COLORMAP_;}
color		{return COLOR_;}
colorscale	{return COLORSCALE_;}
colorspace	{return COLORSPACE_;}
cols		{return COLS_;}
command		{return COMMAND_;}
compass		{return COMPASS_;}
contour		{return CONTOUR_;}
convert         {return CONVERT_;}
coordinates	{return COORDINATES_;}
copy            {return COPY_;}
count		{return COUNT_;}
cross		{return CROSS_;}
cursor		{return CURSOR_;}
create		{return CREATE_;}
crosshair	{return CROSSHAIR_;}
cube		{return CUBE_;}
cut		{return CUT_;}
cmyk		{return CMYK_;}
data		{return DATA_;}
datamin		{return DATAMIN_;}
datasec		{return DATASEC_;}
debug		{return DEBUG_;}
degrees		{return DEGREES_;}
default		{return DEFAULT_;}
delete		{return DELETE_;}
depth		{return DEPTH_;}
detector	{return DETECTOR_;}
diamond		{return DIAMOND_;}
distance	{return DISTANCE_;}
ds9		{return DS9_;}
ecliptic	{return ECLIPTIC_;}
ellipse		{return ELLIPSE_;}
edit		{return EDIT_;}
end		{return END_;}
equatorial	{return EQUATORIAL_;}
erase		{return ERASE_;}
export		{return EXPORT_;}
ext		{return EXT_;}
factor		{return FACTOR_;}
false		{return FALSE_;}
fast		{return FAST_;}
fg		{return FG_;}
file		{return FILE_;}
filter		{return FILTER_;}
fit		{return FIT_;}
fits		{return FITS_;}
fitsy		{return FITSY_;}
fixed		{return FIXED_;}
fk4		{return FK4_;}
fk5		{return FK5_;}
font		{return FONT_;}
front		{return FRONT_;}
full		{return FULL_;}
function	{return FUNCTION_;}
galactic	{return GALACTIC_;}
gaussian	{return GAUSSIAN_;}
get		{return GET_;}
global		{return GLOBAL_;}
graphics	{return GRAPHICS_;}
gray		{return GRAY_;}
grid		{return GRID_;}
gz		{return GZ_;}
handle		{return HANDLE_;}
has		{return HAS_;}
header		{return HEADER_;}
height		{return HEIGHT_;}
hide		{return HIDE_;}
high		{return HIGH_;}
highlite	{return HIGHLITE_;}
histequ		{return HISTEQU_;}
histogram	{return HISTOGRAM_;}
hms		{return HMS_;}
horizontal	{return HORIZONTAL_;}
icrs		{return ICRS_;}
id		{return ID_;}
iis		{return IIS_;}
image		{return IMAGE_;}
include		{return INCLUDE_;}
incr		{return INCR_;}
info		{return INFO_;}
integer		{return INTEGER_;}
interpolate	{return INTERPOLATE_;}
iraf		{return IRAF_;}
irafmin		{return IRAFMIN_;}
j2000		{return J2000_;}
jpeg		{return JPEG_;}
key		{return KEY_;}
keyword		{return KEYWORD_;}
label		{return LABEL_;}
length		{return LENGTH_;}
level		{return LEVEL_;}
line		{return LINE_;}
linear		{return LINEAR_;}
list		{return LIST_;}
load		{return LOAD_;}
local		{return LOCAL_;}
log		{return LOG_;}
low		{return LOW_;}
magnifier	{return MAGNIFIER_;}
map		{return MAP_;}
marker		{return MARKER_;}
master		{return MASTER_;}
message		{return MESSAGE_;}
method		{return METHOD_;}
minmax		{return MINMAX_;}
mmap		{return MMAP_;}
mmapincr	{return MMAPINCR_;}
mode		{return MODE_;}
mosaic		{return MOSAIC_;}
motion		{return MOTION_;}
move		{return MOVE_;}
name		{return NAME_;}
nan		{return NAN_;}
new		{return NEW_;}
next		{return NEXT_;}
no		{return NO_;}
none		{return NONE_;}
now		{return NOW_;}
number		{return NUMBER_;}
object		{return OBJECT_;}
off		{return OFF_;}
on		{return ON_;}
option		{return OPTION_;}
orient		{return ORIENT_;}
pan		{return PAN_;}
panda		{return PANDA_;}
panner		{return PANNER_;}
param		{return PARAM_;}
parser		{return PARSER_;}
paste		{return PASTE_;}
path            {return PATH_;}
perf		{return PERF_;}
physical	{return PHYSICAL_;}
pixels		{return PIXELS_;}
png		{return PNG_;}
point		{return POINT_;}
polygon		{return POLYGON_;}
postscript	{return POSTSCRIPT_;}
ppm		{return PPM_;}
preserve	{return PRESERVE_;}
projection	{return PROJECTION_;}
property	{return PROPERTY_;}
pros		{return PROS_;}
publication	{return PUBLICATION_;}
radius		{return RADIUS_;}
region		{return REGION_;}
replace		{return REPLACE_;}
resample	{return RESAMPLE_;}
reset		{return RESET_;}
resolution	{return RESOLUTION_;}
rgb		{return RGB_;}
root		{return ROOT_;}
rotate		{return ROTATE_;}
ruler		{return RULER_;}
sample		{return SAMPLE_;}
saoimage	{return SAOIMAGE_;}
saotng		{return SAOTNG_;}
save		{return SAVE_;}
scan		{return SCAN_;}
scientific	{return SCIENTIFIC_;}
scope		{return SCOPE_;}
segment		{return SEGMENT_;}
select		{return SELECT_;}
set		{return SET_;}
sexagesimal	{return SEXAGESIMAL_;}
shared		{return SHARED_;}
shift		{return SHIFT_;}
shmid		{return SHMID_;}
show		{return SHOW_;}
size		{return SIZE_;}
sky		{return SKY_;}
slave		{return SLAVE_;}
slice		{return SLICE_;}
smmap		{return SMMAP_;}
smooth		{return SMOOTH_;}
socket		{return SOCKET_;}
socketgz	{return SOCKETGZ_;}
source		{return SOURCE_;}
sqrt		{return SQRT_;}
squared		{return SQUARED_;}
sshared		{return SSHARED_;}
status		{return STATUS_;}
sum		{return SUM_;}
system		{return SYSTEM_;}
table		{return TABLE_;}
tag		{return TAG_;}
text		{return TEXT_;}
thick		{return THICK_;}
tiff		{return TIFF_;}
to		{return TO_;}
tophat		{return TOPHAT_;}
true		{return TRUE_;}
type		{return TYPE_;}
undo		{return UNDO_;}
unload		{return UNLOAD_;}
unselect 	{return UNSELECT_;}
update		{return UPDATE_;}
user		{return USER_;}
value		{return VALUE_;}
var		{return VAR_;}
view		{return VIEW_;}
version		{return VERSION_;}
vertex		{return VERTEX_;}
vertical	{return VERTICAL_;}
warp		{return WARP_;}
wcs		{return WCS_;}
wcsa		{return WCSA_;}
wcsb		{return WCSB_;}
wcsc		{return WCSC_;}
wcsd		{return WCSD_;}
wcse		{return WCSE_;}
wcsf		{return WCSF_;}
wcsg		{return WCSG_;}
wcsh		{return WCSH_;}
wcsi		{return WCSI_;}
wcsj		{return WCSJ_;}
wcsk		{return WCSK_;}
wcsl		{return WCSL_;}
wcsm		{return WCSM_;}
wcsn		{return WCSN_;}
wcso		{return WCSO_;}
wcsp		{return WCSP_;}
wcsq		{return WCSQ_;}
wcsr		{return WCSR_;}
wcss		{return WCSS_;}
wcst		{return WCST_;}
wcsu		{return WCSU_;}
wcsv		{return WCSV_;}
wcsw		{return WCSW_;}
wcsx		{return WCSX_;}
wcsy		{return WCSY_;}
wcsz		{return WCSZ_;}
wfpc2		{return WFPC2_;}
width		{return WIDTH_;}
xy		{return XY_;}
yes		{return YES_;}
zmax		{return ZMAX_;}
zscale		{return ZSCALE_;}
zoom		{return ZOOM_;}

[+-]?{D}+	{ // Integer
		  frlval.integer = atoi(yytext);
		  frsign = (yytext[0]!='-') ? 1 : -1;
		  return INT;
		}

[+-]?{D}+"."?({E})? |
[+-]?{D}*"."{D}+({E})? { // Real Number
		  frlval.real = atof(yytext);
		  return REAL;
		}

0[xX][0-9a-fA-F]+ { // Pointer
		  frlval.ptr = (void*)strtoul(yytext,NULL,16);
		  return POINTER;
		}

[+-]?{D}+"."?d |
[+-]?{D}*"."{D}+d { // degrees
		  yytext[yyleng-1] = '\0';
		  frlval.real = atof(yytext);
		  return DEGREE;
		}	

[+-]{D}+"."?r |
[+-]{D}*"."{D}+r { // radians
		  yytext[yyleng-1] = '\0';
		  frlval.real = atof(yytext);
		  return RADIAN;
		}

{D}+"."?' |
{D}*"."{D}+'	{ // minutes of arc
		  yytext[yyleng-1] = '\0';
		  frlval.real = atof(yytext);
		  return ARCMINUTE;
		}	

{D}+"."?\" |
{D}*"."{D}+\"	{ // seconds
		  yytext[yyleng-1] = '\0';
		  frlval.real = atof(yytext);
		  return ARCSECOND;
		}

[+-]?{D}+h	{ // hours
		  yytext[yyleng-1] = '\0';
		  frlval.integer = atoi(yytext);
		  frsign = (yytext[0]!='-') ? 1 : -1;
		  return HOUR;
		}	

{D}+m		{ // minutes
		  yytext[yyleng-1] = '\0';
		  frlval.integer = atoi(yytext);
		  return MINUTE;
		}	

{D}+"."?s |
{D}*"."{D}+s	{ // seconds
		  yytext[yyleng-1] = '\0';
		  frlval.real = atof(yytext);
		  return SECOND;
		}

[+-]?{D}+:{D}+:{D}+"."? |
[+-]?{D}+:{D}+:{D}*"."{D}+ { // sexagesimal
		  strncpy(frlval.str,yytext,1024);
		  return SEXSTR;
		}	

\"[^\"\n]*\" | 
\'[^\'\n]*\'	{ // Quoted String
		  strncpy(frlval.str,yytext+1,yyleng-2); // skip the " " 
	          frlval.str[yyleng-2] = '\0'; // Remove the '"' 
		  return STRING;
		}

\{[^\}\n]*\} 	{ // Quoted String
		  strncpy(frlval.str,yytext+1,yyleng-2); // skip the '{'
	          frlval.str[yyleng-2] = '\0'; // Remove the '}'
		  return STRING;
		}

[!-~][!-~]+	{ // General String-- at least 2 printable chars
		  strncpy(frlval.str,yytext,1024);
		  return STRING;
		}

[ \t]+		{ // White Spaces
		} 

.		{ // Else, return the char
		  return toupper(yytext[0]);
		}

%%
