// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __lut_h__
#define __lut_h__

#include "colormap.h"
#include "rgb.h"

class LUTColorMap : public ColorMapInfo {
protected:
  int size;
  RGBColor* colors;

public:
  LUTColorMap();
  ~LUTColorMap();

  int load();
  int save(const char*);

  unsigned char getRedChar(int, int);
  unsigned char getGreenChar(int, int);
  unsigned char getBlueChar(int, int);

  unsigned short getRedShrt(int, int);
  unsigned short getGreenShrt(int, int);
  unsigned short getBlueShrt(int, int);

  friend ostream& operator<<(ostream&, LUTColorMap&);
};

#endif

