#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc UpdatePixelTable {which x y sys} {
    global pixel
    global pixelValues

    if {$pixel(view)} {
	$which get pixels table $sys $x $y $pixel(size) pixelValues
    }
}

proc PixelTableDisplay {} {
    global ds9
    global pixel
    global menu

    set pixel(view) 1
    if {[winfo exist $pixel(top)]} {
	raise $pixel(top)
	PixelTableSize
	return
    }
	
    # create the pixel table window

    set title "Pixel Table"
    set w $pixel(top)
    set mb $pixel(mb)

    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW PixelTableDestroy

    $w configure -menu $mb

    # simple menus

    menu $mb -tearoff 0
    $mb add cascade -label File -menu $mb.file
    $mb add cascade -label Edit -menu $mb.edit
    $mb add cascade -label Size -menu $mb.size

    menu $mb.file -tearoff 0
    $mb.file add command -label "Save..." -command SavePixelTable
    $mb.file add separator
    $mb.file add command -label "Close" -command PixelTableDestroy

    menu $mb.edit -tearoff 0
    $mb.edit add command -label "Cut" -state disabled
    $mb.edit add command -label "Copy" -command CopyPixelTable
    $mb.edit add command -label "Paste" -state disabled
    $mb.edit add command -label "Clear" -state disabled

    menu $mb.size -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.size add radiobutton -label "3x3" -variable pixel(size) -value 3 \
	-command PixelTableSize
    $mb.size add radiobutton -label "5x5" -variable pixel(size) -value 5 \
	-command PixelTableSize
    $mb.size add radiobutton -label "7x7" -variable pixel(size) -value 7 \
	-command PixelTableSize
    $mb.size add radiobutton -label "9x9" -variable pixel(size) -value 9 \
	-command PixelTableSize

    frame $w.table
    pack $w.table

    selection handle . CopyPixelTableHandle

    PixelTableSize
}

proc PixelTableDestroy {} {
    global pixel
    global pixelValues
    
    set pixel(view) 0
    if {[winfo exist $pixel(top)]} {
	destroy $pixel(top)
	destroy $pixel(mb)
    }

    if {[info exists pixelValues]} {
	unset pixelValues
    }
}

proc PixelTableSize {} {
    global pixel
    global pixelValues

    set w $pixel(top)

    # ungrid all
    for {set j 0} {$j<=$pixel(maxsize)} {incr j} {
	for {set i 0} {$i<=$pixel(maxsize)} {incr i} {
	    if {[winfo exists $w.table.b$i$j]} {
		grid forget $w.table.b$i$j
	    }
	}
    }
    if {[info exists pixelValues]} {
	unset pixelValues
    }

    # corner
    set i 0
    set j 0
    if {![winfo exists $w.table.b$i$j]} {
	label $w.table.b$i$j -width 12 -relief groove -borderwidth 1
    }
    grid $w.table.b$i$j -column $i -row $j

    # x (column)
    set j 0
    for {set i 1} {$i<=$pixel(size)} {incr i} {
	if {![winfo exists $w.table.b$i$j]} {
	    label $w.table.b$i$j -width 12 -relief groove -borderwidth 1 \
		-textvariable pixelValues($i$j) -foreground blue
	}
	grid $w.table.b$i$j -column $i -row $j
    }

    # y (row)
    set i 0
    for {set j 1} {$j<=$pixel(size)} {incr j} {
	if {![winfo exists $w.table.b$i$j]} {
	    label $w.table.b$i$j -width 12 -relief groove -borderwidth 1 \
		-textvariable pixelValues($i$j) -foreground blue
	}
	grid $w.table.b$i$j -column $i -row [expr $pixel(size)-$j+1] 
    }

    # body
    set half [expr ($pixel(size)+1)/2]
    set fg [$w.table.b00 cget -foreground]

    for {set i 1} {$i<=$pixel(size)} {incr i} {
	for {set j 1} {$j<=$pixel(size)} {incr j} {
	    if {![winfo exists $w.table.b$i$j]} {
		label $w.table.b$i$j -width 12 -relief groove -borderwidth 1 \
		    -textvariable pixelValues($i$j)
	    }
	    if {($i==$half) && ($j==$half)} {
		$w.table.b$i$j configure -foreground red
	    } else {
		$w.table.b$i$j configure -foreground $fg
	    }
	    grid $w.table.b$i$j -column $i -row [expr $pixel(size)-$j+1]
	}
    }

    # show
    pack $w.table
}

proc ClearPixelTable {} {
    global pixel
    global pixelValues

    if {$pixel(view)} {
	for {set i 0} {$i<=$pixel(size)} {incr i} {
	    for {set j 0} {$j<=$pixel(size)} {incr j} {
		set pixelValues($i$j) {}
	    }
	}
    }
}

proc RenderPixelTable {varname} {
    upvar $varname var
    global pixel
    global pixelValues

    # col header
    append var "            "
    for {set i 1} {$i<=$pixel(size)} {incr i} {
	set msg [format "%12s" $pixelValues(${i}0)]
	append var "$msg"
    }
    append var "\n"

    append var "            "
    for {set i 1} {$i<=$pixel(size)} {incr i} {
	append var " -----------"
    }
    append var "\n"

    # body
    for {set j $pixel(size)} {$j>=1} {incr j -1} {
	set msg [format "%10s" $pixelValues(0${j})]
	append var "$msg |"
	for {set i 1} {$i<=$pixel(size)} {incr i} {
	    set msg [format "%12.11s" $pixelValues($i$j)]
	    append var "$msg"
	}
	append var "\n"
    }
}

proc CopyPixelTable {} {
    global pixel

    set pixel(copy) {}
    RenderPixelTable pixel(copy)

    selection own -command UnCopyPixelTable .

    clipboard clear
    clipboard append $pixel(copy)
}

proc UnCopyPixelTable {} {
    global pixel

    set pixel(copy) {}
}

proc CopyPixelTableHandle {offset bytes} {
    global pixel

    if {$pixel(copy) != ""} {
	return [string range $pixel(copy) $offset [expr $offset+$bytes]]
    }
}

proc SavePixelTable {} {
    set filename [SaveFileDialog pixelfbox]

    if {$filename != {}} {
	set file [open $filename w]

	set cp {}
	RenderPixelTable cp
	puts -nonewline $file $cp
	
	close $file
    }
}
