/*
*  Rubrica
*  file: search_cb.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "search.h"
#include "search_cb.h"
#include "search_int.h"
#include "prefer.h"
#include "browse.h"


void on_update_search_column(GtkWidget *optmenu, gpointer data)
{
  GtkTreeViewColumn *column;
  gint pos;
  gchar *title;

  g_return_if_fail(data != NULL);

  column = (GtkTreeViewColumn *)data;
  pos = gtk_option_menu_get_history(GTK_OPTION_MENU(optmenu));
  title = rubrica_search_get_option_label(pos);
  
  if (title)
    gtk_tree_view_column_set_title(GTK_TREE_VIEW_COLUMN(column), title);  
}


void rubrica_search_row_selected(GtkTreeSelection *select, gpointer data)
{
  Rubrica *rubrica;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *path_str;

  
  rubrica = rubrica_get_current_rubrica();

  if (gtk_tree_selection_get_selected(select, &model, &iter))
    {
      gtk_tree_model_get(model, &iter, SEARCH_RESULT_PATH, &path_str, -1);
      rubrica_browse_nth_card(path_str);
    }  
}

/*
void
on_search_close_clicked(GtkButton *button, gpointer user_data)
{
  gtk_widget_hide(GTK_WIDGET(user_data));
}
*/
