/*
*  Rubrica
*  file: rubrica.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_H
#define _RUBRICA_H

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "rubrica_type.h"

typedef struct _Rubrica          Rubrica;
typedef struct _RubricaItem      RubricaItem;
typedef struct _RubricaPersonal  RubricaPersonal;
typedef struct _RubricaNet       RubricaNet;
typedef struct _RubricaTelephone RubricaTelephone;
typedef struct _RubricaAddress   RubricaAddress;
typedef struct _RubricaCompany   RubricaCompany;
typedef struct _RubricaWork      RubricaWork;
typedef struct _RubricaNotes     RubricaNotes;

struct _Rubrica
{
  /* public */
  gboolean new;            /* true if this is a new addressbook  */
  gboolean modified;       /* true if rubrica is modified */
  gboolean empty;          /* true if rub list is empty   */
  
  gchar *name;            /* addressbook's name */
  gchar *path;            /* addressbook's path */
  gchar *tmpfile;          /* temp file's name, used in autosave */

  gint items;              /* # of item in current rubrica */
  gint index;              /* # of item currently show */
  gchar *list_path;        /* item's path (GtkTreePath) */

  /* private */
  gint page;               /* current notebook's page */  

  GtkWidget *parent;       /* notebook's page that store this item */  
  GtkTreeView *view;       /* ptr to the tree_view */
};


struct _RubricaPersonal
{
  /* name */
  gchar *first;
  gchar *middle;
  gchar *last;

  gchar *profession;
  gchar *prefix;
  gchar *title;

  gboolean birthknow;
  time_t birthdate;
};

struct _RubricaAddress
{
  gchar *street;
  gchar *number;
  gchar *zip;
  gchar *city;
  gchar *province;
  gchar *state;
  gchar *country;
};

struct _RubricaNet
{
  GList *web;
  GList *email;  
};


struct _RubricaTelephone
{
  GList *telephone;
};


struct _RubricaCompany
{
  gchar *name;
  gchar *street;
  gchar *number;
  gchar *zip;
  gchar *city;
  gchar *province;
  gchar *country;
  gchar *web;
  gchar *email;
  gchar *operator;
  gchar *fax;
  gchar *green;
  gchar *customer_care;
  gchar *notes;
};

struct _RubricaWork
{
  gchar *assigment;
  gchar *organization;
  gchar *department;
  gchar *subdep;
  gchar *secretary;
  gchar *telephone;
};

struct _RubricaNotes
{
  gboolean is_married;
  gboolean has_children;
  gboolean birthknow;
  gboolean anniverknow;

  time_t birthdate;
  time_t anniverdate;

  gchar *spouse;
  
  gchar *children;
  gchar *hobbies;
  gchar *notes;

  gchar *pubkey;
};


struct _RubricaItem 
{
  gboolean delete;
  RubricaGroupType group;

  gchar *card;

  RubricaPersonal  personal;
  RubricaAddress   address;
  RubricaNet       net;
  RubricaTelephone phone;
  RubricaCompany   company;
  RubricaWork      work;
  RubricaNotes     notes;

  time_t created;
  time_t last_change;
};


Rubrica *rubrica_new(void);
RubricaItem* rubrica_item_new(void);

void rubrica_init(void);
void rubrica_init_gconf(void);
void rubrica_init_dictionary(void);
void rubrica_init_item(RubricaItem *item);

gboolean rubrica_start_with_user_addressbook();
gchar*   rubrica_get_book(void);
void     rubrica_update_time(void);

void     rubrica_set_just_start(gboolean bool);
gboolean rubrica_get_just_start(void);

Rubrica* rubrica_get_current_rubrica(void);
void rubrica_set_current_rubrica(Rubrica* rubrica);
// Rubrica* rubrica_get_rubrica(GtkTreeView *view);         
Rubrica* rubrica_get_child(GtkWidget *parent); 
Rubrica* rubrica_get_nth_rubrica(gint n);
RubricaItem* rubrica_get_nth_item(Rubrica *rubrica, gint n);

/* ----  metodi operanti sulla struttura Rubrica  ---- */

/****
 *
 *  get
 *
 ****/
gboolean rubrica_is_new(Rubrica *rubrica);
gboolean rubrica_is_empty(Rubrica *rubrica);
gboolean rubrica_is_modified(Rubrica *rubrica);

gchar *rubrica_get_path(Rubrica *rubrica);
gchar *rubrica_get_name(Rubrica *rubrica);
gchar *rubrica_get_tmpfile(Rubrica *rubrica);

gint rubrica_get_items(Rubrica *rubrica);
gint rubrica_get_index(Rubrica *rubrica);
gchar *rubrica_get_list_path(Rubrica *rubrica);

GtkWidget* rubrica_get_rubrica_parent(Rubrica *rubrica);
GtkWidget* rubrica_get_view(Rubrica *rubrica);     

gint rubrica_get_current_page(void);


/****
 *
 *  set
 *
 ****/
// void rubrica_set_rubrica(gpointer ptr);

void rubrica_set_new(Rubrica *rubrica, gboolean state);
void rubrica_set_empty(Rubrica *rubrica, gboolean state);
void rubrica_set_modified(Rubrica *rubrica, gboolean state);

void rubrica_set_path(Rubrica *rubrica, gchar *str);
void rubrica_set_name(Rubrica *rubrica, gchar *str);
void rubrica_set_tmpfile(Rubrica *rubrica, gchar *str);

void rubrica_set_items(Rubrica *rubrica, gint n);
void rubrica_set_index(Rubrica *rubrica, gint index);
void rubrica_set_list_path(Rubrica *rubrica, gchar *path);


/* ************************************************** 
   metodi per:
   - l'inserimento,  (insert item)
   - cancellazione   (delete item)
   - modifica        (modify item)
   di un elemento di rubrica nella lista rubrica       
*/
void rubrica_append_item(Rubrica *rubrica, RubricaItem *r);
void rubrica_insert_item(Rubrica *rubrica, RubricaItem *r, gint index);
void rubrica_modify_item(Rubrica *rubrica, RubricaItem *r, gint index);
gboolean rubrica_delete_selected_item(Rubrica *rubrica);
gboolean rubrica_delete_last_item(Rubrica *rubrica);
gboolean rubrica_delete_nth_item(Rubrica *rubrica, gint n);

/*  Free memory
*/
void rubrica_free_memory(Rubrica *rubrica);
void rubrica_free_item_data(RubricaItem *item);
void rubrica_free_string(gchar *str);


/*  funzioni per:
    taglia, copia, incolla (cut, copy, paste)
*/
// void rubrica_buffer_set_item(RubricaItem *item);
void rubrica_item_cut(Rubrica *rubrica);
void rubrica_item_copy(Rubrica *rubrica);
void rubrica_item_paste(Rubrica *rubrica);

/* Closing function 
 */
gboolean rubrica_others_are_modified();
void rubrica_close_rubrica(Rubrica *rubrica);

gchar *rubrica_convert_time(time_t t, gboolean has_hour);   /* spostare in rubrica_utils */

#endif










