/*
*  Rubrica
*  file: druid_int.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _DRUID_INT_H
#define _DRUID_INT_H

#include <gnome.h>

GtkWidget* rubrica_druid_create_druid (void);

void rubrica_druid_start_page(GtkWidget *druid, GdkPixbuf *pixbuf);
void rubrica_druid_first_page(GtkWidget *druid, GdkPixbuf *pixbuf,
			      gchar *home);
void rubrica_druid_second_page(GtkWidget *druid, GdkPixbuf *pixbuf,
			       gchar *home);
void rubrica_druid_finish_page(GtkWidget *druid, GdkPixbuf *pixbuf);

void on_druid_finish (GnomeDruid *gnomedruid, gpointer user_data);
void on_druid_cancel (GnomeDruid *gnomedruid, gpointer user_data);

void on_check_book_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_check_folder_toggled (GtkToggleButton *togglebutton, 
			      gpointer user_data);
void on_check_script_toggled (GtkToggleButton *togglebutton,
			      gpointer user_data);

void on_entry_book_activate (GtkEditable *editable, gpointer user_data);
void on_entry_book_changed (GtkEditable *editable, gpointer user_data);

void on_entry_folder_activate (GtkEditable *editable, gpointer user_data);
void on_entry_folder_changed (GtkEditable *editable, gpointer user_data);

void on_entry_script_activate (GtkEditable *editable, gpointer user_data);
void on_entry_script_changed (GtkEditable *editable, gpointer user_data);


#endif
