
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

RBucket *
rbucket_new (unsigned int size)
{
    RBucket *bucket;

    bucket = rchunk_alloc (sizeof (RBucket));
    bucket->buckets = NULL;
    bucket->size = size;
    bucket->fills = rlist_new ();

    return (bucket);
}

void
rbucket_destroy (RBucket *bucket)
{
    RListEntry *entry;

    RLIST_FOREACH (bucket->fills, entry) {
        free (entry->data);
        rchunk_free (entry, sizeof (RListEntry));
    } RFOREACH_CLOSE;

    rlist_free (bucket->fills);
    rchunk_free (bucket, sizeof (RBucket));
}

void
rbucket_empty (RBucket *bucket)
{
    RListEntry *entry;

    RLIST_FOREACH (bucket->fills, entry) {
        free (entry->data);
        rlist_remove (bucket->fills, entry);
        rchunk_free (entry, sizeof (RListEntry));
    } RFOREACH_CLOSE;
}


#define NUMCHUNKS 64

void *
rbucket_fill0__P (RBucket *bucket)
{
    void *mem;

    mem = rbucket_fill__P (bucket);

    memset (mem, 0, bucket->size);

    return (mem);
}

void *
rbucket_fill__P (RBucket *bucket)
{
    RBucketChunk__P *curchunk;
    RBucketChunk__P *nextchunk;
    char *newmem;
    int i;
    RListEntry *entry;

    newmem = malloc (NUMCHUNKS * bucket->size);

    /* Save off this chunk of memory. */
    entry = rchunk_alloc (sizeof (RListEntry));
    entry->data = newmem;
    rlist_append (bucket->fills, entry);

    //printf ("allocating new buckets - start of new mem at %p\n", newmem);

    curchunk = (RBucketChunk__P *) newmem;

    bucket->buckets = curchunk;

    for (i = 1; i < NUMCHUNKS; i++) {
        newmem += bucket->size;
        nextchunk = (RBucketChunk__P *) newmem;

        curchunk->next = nextchunk;

        curchunk = nextchunk;
    }

    /* ensure that the last block has a NULL pointer */
    curchunk->next = NULL;

    /* remember the head so we can return it. */
    curchunk = bucket->buckets;

    /* Make the head point to the next bucket. */
    bucket->buckets = bucket->buckets->next;

    /* Return the head. */
    return (curchunk);
}
    

