/*
 * robprofile.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares the ProfilePlugin class.
  */

#ifndef __RT_PROFILE__
#define __RT_PROFILE__

#include "robfrontend.h"
#include "robmanage.h"
#include "robbase.h"

#include <rtsystem.h>
#include <rtstreams.h>

using namespace lrt;

namespace rt {

/// Type of Profile that is generated
enum ProfileMode {
	profCount,     ///< count number of instruction executions
	profTime,      ///< count time spent for instructions
	profFailure    ///< measure permilleage of failed instructions
};

/// The RoboTour profiler
class ProfilePlugin : public FrontendPlugin  
{
public:
	virtual FpInterpretePos getInterpretePos();
	virtual String getName();
	virtual String getHelpText();
	virtual bool interpreteParams(const Array<String>& params, Array<bool>& used);
	virtual void fillOptions(SimOptions& options);

	/// Get the profile mode.
	ProfileMode getMode() { return mode; }
	/// Sets the profile mode. Change has no effect after the tournament has been started. 
	/// Also the profiler needs to be 'active'ated separately.
	void setMode(ProfileMode m) { mode = m; }

	ProfilePlugin(Frontend* parent);
	~ProfilePlugin() {}
private:
	ProfileMode mode;
};

struct ProfileBankData {
	String name;
	Map<Instr*, unsigned int> data;
};

typedef Map< Bank*, ProfileBankData >  ProfileMap; 

class ProfileSupervisor : public ExecSupervisor
{
public:
	ProfileSupervisor(Frontend* parent, ProfileMode mode);
	virtual void initSim(Simulation* const curSim);
	virtual void onExec(Instr* instr, Bank* bank, Task* task);
	virtual void exitSim(Simulation* const curSim);
private:
	enum trool { // troolean value (for more examples, cf. Win32 API)
		trError = -1,
		trFalse = 0,
		trTrue = 1
	};

	ProfileMap profData;
	void printProgram(Program*);
	void printHtml(const String& profFileName); 
	void printInstrs(Bank*, OutputStream* out);
	// is the bank in one of the programs of that simulation? 
	bool isReachable(Bank*, const String& name, Simulation*);
	// NOTE. We don't want to detect the fatal errors again (the instruction already does that
	// by itself, and they can be shown) but the more subtle cases here :
	//   * trying to create or move when there is already a bot in front of you
	//   * trying to trans or rtrans when there is no bot in front of you
	//   * insert others here...
	trool detectFailure(Instr* instr, Bank* bank, Task* task);

	ProfileMode mode;
	Frontend* parent;
};

} // namespace

#endif

