
                                        #
# This is Gtk implementation of the tkdensity demo in the tcltk
# package.
#
#

gtkDensity <-
function()
{
 win <- gtkWindow(show = FALSE)
 win$SetTitle("Density Demo!")
 gtkFrame("Distribution")

 xlim <- NULL
 sampleSize <- 50
 kernel <- "Gaussian"
 distribution <- "Normal"
 bw <- 1.0
 
 createButtonGroup <-
   function(labels, cb = NULL, box = gtkVBox(TRUE, 3)) {
      b <- NULL
      
      for(i in labels) {
        b <- gtkRadioButton(b, i)
        if(!is.null(cb))
          b$AddCallback("clicked", cb, data = i)
        box$PackStart(b)
      }

      box
   }
 
 distnBox <- createButtonGroup(c("Normal", "Exponential"),
                            function(cmd, w) {
                               distribution <<- cmd
                               regen()
                            })
 kernelBox <- createButtonGroup(c("Gaussian", "Epanechnikov", "Rectangular", "triangular", "Cosine"),
                             function(cmd, w) {
                               kernel <<- cmd
                               replot()
                             })

 sampleSizeBox <- createButtonGroup(as.character(c(50, 100, 200, 300, 10000)),
                                    function(cmd, w) {
                                      sampleSize <<- as.numeric(cmd)
                                      regen()
                                    })
 


 tb <- gtkTable(4, 3, FALSE)
 f <- gtkFrame("Distribution")
 f$Add(distnBox)
 tb$AttachDefaults(f, 0, 1, 0, 1)
 f <- gtkFrame("Kernel")
 f$Add(kernelBox)
 tb$AttachDefaults(f, 0, 1, 1, 2)
 f <- gtkFrame("Sample Size")
 f$Add(sampleSizeBox) 
 tb$AttachDefaults(f, 1, 2, 0, 1)

 f <- gtkFrame("Bandwidth")
 adj <- gtkAdjustment(bw, 0.05, 2.0, .05, .05, .05)
 slider <- gtkHScale(adj)
 f$Add(slider)
 adj$AddCallback("value-changed",
                 function(adj) {
                   bw <<- adj$GetValue()
                   replot()
                 })
 
 tb$AttachDefaults(f, 1, 2, 1, 2)
 
 win$Add(tb)
 win$Show()

 regen <- function(...) {
   f <- switch(distribution, Normal=rnorm, Exponential=rexp)
   y <<- f(sampleSize)
   xlim <<- range(y) + c(-2, 2)
   replot()
 }

 replot <- function(...) {
   if(is.null(y)) return()
#   main <- paste("Density: x ~", distribution, ", n = ", sampleSize, ", kernel =", kernel, ", band-width", bw, sep=" ")
   main <- ""
   eval(substitute(plot(density(y, bw = bw, kernel = tolower(kernel)), xlim=xlim, main=main)))
   points(y, rep(0, sampleSize))
 }

 regen()  
}  
