(************************************************************
 *
 * A part of Regexp/OCaml module.
 * 
 * (c) 2002-2003 Yutaka Oiwa. All Rights Reserved.
 * 
 * This file is distributed under the terms of the GNU Library
 * General Public License, with the special exception on
 * linking described in file ../LICENSE.
 *
 ************************************************************)

(* Available kinds of declaration. Currently only an expression can be declared. *)

type decl_type = Expr of MLast.expr

(* Given a tag string which is passed for declare,
   returns a name of symbol for that tag
   if it is already cached and still available. *)

val lookup_cached :
  package:string -> string -> string option

(* Declare a value at the top of current structure-item.
   If tag is given, the same result may be reusable later.
*)

val declare :
  package:string ->
  ?tag:string -> string -> decl_type -> unit

(* generate a unique symbol. *)

val gensym : package:string -> string

exception Not_possible

(* Insert an declaration into a structure-item.
   Raises the exception Not_possible if the passed structure-item is
   not processible. *)

val insert_local :
  MLast.str_item ->
  (bool * (MLast.patt * MLast.expr) list) list ->
  MLast.str_item

(* Utility function: picks up all variables bound by given pattern. *)
val pickup_variables : MLast.patt -> string list

val dummy_loc : MLast.loc
