#ifndef header_race_music
#define header_race_music

#include <ClanLib/sound.h>

#ifdef RACE_VORBIS
	#include <ClanLib/vorbis.h>
#endif

class Music
{
 public:
	static void init();
	static void update();
	
	static bool load_track(int);
	static void play_track();
	static void fade_out();
	
	static short next_track;
	
	static CL_SoundBuffer *load_ogg( std::string res_name, CL_ResourceManager *res )
	{
	  #ifdef RACE_VORBIS
		CL_Resource resource = res->get_resource( res_name );
		resource.load();
		
		return CL_SoundBuffer::create( new CL_VorbisSoundProvider(resource.get_full_location()) );
	  #endif
	}
	
 private:
	static CL_ResourceManager music_res;
	
	static CL_SoundBuffer *buf;
	static CL_SoundBuffer_Session playback;
	
	static bool stop_music;
	static char last_track;
};

#endif 

