/***************************************************************************
                          qwordarrayoption.h  -  description
                             -------------------
    begin                : Mon Oct 30 2000
    copyright            : (C) 2000 by M. Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef QWORDARRAYOPTION_H
#define QWORDARRAYOPTION_H

#include "qsaneoption.h"
#include <qstring.h>
#include <qarray.h>
#include <qpointarray.h>
extern "C"
{
#include <sane/sane.h>
}
/**
  *@author M. Herder
  */

class QDoubleSpinBox;
class QPushButton;
class QLabel;
class QCurveWidget;
class QComboBox;

class QWordArrayOption : public QSaneOption
{
Q_OBJECT
public:
	QWordArrayOption(QString title,QWidget* parent,
                   SANE_Value_Type type=SANE_TYPE_INT,const char* name=0);
	~QWordArrayOption();
  /**  */
  QArray<SANE_Word> getValue();
  /**  */
  SANE_Value_Type getSaneType();
  /**  */
  void setRange(int min, int max);
  /**  */
  void setQuant(int min);
  /**  */
  void setValue(QArray<SANE_Word> array);
  /**  */
  void calcDataArray();
  QPointArray pointArray();
  /**  */
  void closeCurveWidget();
private:
  /**  */
  QCurveWidget* mpCurveWidget;
  /**  */
  QPushButton* mpSetButton;
  /**  */
  QPushButton* mpResetButton;
  /**  */
  QPushButton* mpCloseButton;
  /**  */
  QDoubleSpinBox* mpGammaSpin;
  /**  */
  QComboBox* mpCurveCombo;
  /**  */
  QPointArray mPointArray;
  /**  */
  QLabel* mpTitleLabel;

  QPushButton* mpShowButton;
  /**  */
  SANE_Word mMaxVal;
  /**  */
  SANE_Word mMinVal;
  /**  */
  SANE_Word mQuant;
  /**  */
  QArray<SANE_Word> mDataArray;
  /**  */
  QWidget* mpArrayWidget;
  /** */
  SANE_Value_Type mValueType;
  /** */
  double mGamma;
  /**  */
  double mOldGamma;
private: // Private methods
  /**  */
  void setCurve();
  /**  */
  void initWidget();
  /** */
  void setPointArray(QPointArray qpa);
  /**  */
  void createCurveWidget();

private slots: // Private slots
  /**  */
  void slotShowOption();
  /**  */
  void slotGammaValue(int value);
  /**  */
  void slotCurveCombo(int index);
public slots:
  /**  */
  void slotReset();
  /**  */
  void slotSet();
};

#endif
