/***************************************************************************
                          temporaryfile.h  -  description
                             -------------------
    begin                : Thu Jun 6 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* This file is based on ktempfile.h, which is part of the KDE libraries.
 * The licence has been changed from LGPL to GPL according to the GPL/LGPL
 *
 *  Copyright (c) 1999 Waldo Bastian <bastian@kde.org>
 *
 **/
#ifndef TEMPORARYFILE_H
#define TEMPORARYFILE_H

/**
  *@author Michael Herder
  */

#include <qstring.h>
#include <stdio.h>
#include <errno.h>

class QFile;
class QTextStream;
class QDataStream;

class TemporaryFile
{
public:
  /**
   * Creates a temporary file with the name:
   *  <filePrefix><six letters><fileExtension>
   *
   * The default @p filePrefix is "/tmp"
   * The default @p fileExtension is ".tmp"
   **/
  TemporaryFile(QString filePrefix=QString::null,int mode = 0600 );

  /**
   * The destructor closes the file.
   * If autoDelete is enabled the file gets unlinked as well.
   **/
  ~TemporaryFile();

  /**
   * Turn automatic deletion on or off.
   * Automatic deletion is off by default.
   **/
  void setAutoDelete(bool autoDelete) { mAutoDelete = autoDelete; }

  /**
   * Returns the status of the file based on errno. (see errno.h)
   * 0 means OK.
   *
   * You should check the status after object creation to check
   * whether a file could be created in the first place.
   *
   * You may check the status after closing the file to verify that
   * the file has indeed been written correctly.
   **/
  int status() const;

  /**
   * The name of the file.
   **/
  QString name() const;

  /**
   * An integer file descriptor open for writing to the file
   **/
  int handle() const;

  /**
   * @return FILE* stream open for writing to the file
   **/
  FILE *fstream();

  /**
   * @return QTextStream open for writing to the file
   **/
  QTextStream *textStream();

  /**
   * @return QDataStream open for writing to the file
   **/
  QDataStream *dataStream();

  /**
   * A QFile open for writing to the file
   **/
  QFile *file();

  /**
   * Unlinks the file from the directory. The file is
   * deleted once the last reader/writer closes it.
   **/
  void unlink();

  /**
   * Closes the file.
   * Returns 'true' is successful, or 'false' if an error has occured.
   * See status() for details about errors.
   **/
  bool close();

protected:
  /**
   * @internal
   * Create function used internally by TemporaryFile and KSaveFile
   **/
  bool create(const QString &filePrefix,int mode);

  void setError(int error) { mError = error; }
private:
  int mError;
  QString mTmpName;
  int mFd;
  FILE* mpStream;
  QFile* mpFile;
  QTextStream* mpTextStream;
  QDataStream* mpDataStream;
  bool mOpen;
  bool mAutoDelete;
};

#endif
