
/*
 * QMyListBox.cpp
 *
 * Copyright (C) 2000, 2001 Markus Janich, Alexander Buck
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */


// Qt
///////
#include <qlineedit.h>

// System
//////////
#include <iostream>

// Own
///////////
#include "QMyListBox.h"


QMyListBox::QMyListBox(QWidget *parent, const char *name, WFlags f)
  : QListBox(parent, name, f),
    m_firstMousePress(true),
    m_fEditable(true),
    m_pqEditField(NULL)
/*********************************************************************/
{
   connect(this, SIGNAL(pressed(QListBoxItem *)),
           this, SLOT(sltCatchPressed(QListBoxItem *)));
   connect(this, SIGNAL(doubleClicked(QListBoxItem *)),
           this, SLOT(sltEditItem(QListBoxItem *)));
}


void QMyListBox::enableEditMode(bool fOnOff) 
/*********************************************************************/
{
   switch (fOnOff) {
      case true:
         if (!m_fEditable) {
            connect(this, SIGNAL(pressed(QListBoxItem *)),
                    this, SLOT(sltCatchPressed(QListBoxItem *)));
            connect(this, SIGNAL(doubleClicked(QListBoxItem *)),
                    this, SLOT(sltEditItem(QListBoxItem *)));
         }
         break;
      case false:
         if (m_fEditable) {
            disconnect(this, SIGNAL(pressed(QListBoxItem *)),
                       this, SLOT(sltCatchPressed(QListBoxItem *)));
            disconnect(this, SIGNAL(doubleClicked(QListBoxItem *)),
                       this, SLOT(sltEditItem(QListBoxItem *)));
         }
         break;
   }
}



void QMyListBox::sltCatchPressed(QListBoxItem *pqItem) 
/*********************************************************************/
{
   if (m_firstMousePress) {
      m_pqItem = pqItem;

      m_firstMousePress = false;
      if (m_pqEditField) {
         delete m_pqEditField;
         m_pqEditField = NULL;
      }

      return;
   }

   if (!pqItem) {
      m_firstMousePress = true;
      return;
   }
   if (pqItem!=m_pqItem) {
      m_firstMousePress = true;
      m_pqItem = pqItem;
      return;
   }

   sltEditItem(pqItem);
}



void QMyListBox::sltEditItem(QListBoxItem *pqItem) 
/*********************************************************************/
{
   m_firstMousePress = true;

   QRect qRect = itemRect(pqItem);

   // first delete existing edit field
   if (m_pqEditField) {
      delete m_pqEditField;
      m_pqEditField = NULL;
   }

   m_pqEditField = new QLineEdit(this);
   connect(m_pqEditField, SIGNAL(returnPressed()),
           this, SLOT(sltChangeItem()));


   m_pqEditField->setText(pqItem->text());
   m_pqEditField->setGeometry(qRect.left(), qRect.top(),
                              qRect.width(), qRect.height());
   m_pqEditField->show();
   m_pqEditField->setFocus();
} 



void QMyListBox::sltChangeItem() 
/*********************************************************************/
{
   int nIndex = index(m_pqItem);
   removeItem(nIndex);

   insertItem(m_pqEditField->text(), nIndex);
    
   delete m_pqEditField;
   m_pqEditField = NULL;

   // select item again
   setSelected(nIndex,true);

   emit sigReturnPressed(nIndex);
}



void QMyListBox::resizeEvent(QResizeEvent *pqEvent) 
/*********************************************************************/
{
   QListBox::resizeEvent(pqEvent);

   if (m_pqEditField) {
      QRect qRect = itemRect(m_pqItem);
      m_pqEditField->setGeometry(qRect.left(), qRect.top(),
                                 qRect.width(), qRect.height());
   }
}
