/***************************************************************************
  fixedspinbox.h
  -------------------
  A spinbox for fixed numbers
  -------------------
  Copyright 1999-2004, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***************************************************************************/

#ifndef FIXEDSPINBOX_H
#define FIXEDSPINBOX_H

#include <qspinbox.h>

class QString;
class QDoubleValidator;

class FixedSpinBox : public QSpinBox  {
    Q_OBJECT
        public:
    // constructor
    FixedSpinBox(QWidget *parent = 0, const char * name = 0,
                 double minvalue = 0.0, double maxvalue = 1.0,
                 double step = 0.1, unsigned precision = 2);
    // destructor
    ~FixedSpinBox();

    // get/set minimum spinbox value
    void setMinimum (double value);
    double minimum() const;
    // get/set maximum spinbox value
    void setMaximum(double value);
    double maximum() const;
    // get/set spinbox step value
    void setSingleStep (double value);
    double singleStep() const;
    // get/set precision
    void setPrecision(unsigned precision);
    unsigned precision() const;
    // get spinbox value
    double value() const;

 signals:
    // send when the spinbox value changes
    void valueChanged(double value);

 public slots:
    // set the value of the spinbox
    void setValue(double value);
    void setValue(const QString &value);

 protected:
    // map the spinbox value to a text string
    virtual QString mapValueToText(int value);
    // map a text string to a spinbox value
    virtual int mapTextToValue(bool* ok);
    // called from validator when value has changed
    virtual void valueChange();

 private:
    double min_;
    double max_;
    double step_;
    unsigned precision_;
    double divisor_;
    double tv_;
};

#endif // FIXEDSPINBOX_H
