#ifndef FORM1_H
#define FORM1_H

#include <qvariant.h>
#include <qdialog.h>
#include <qtimer.h>
#include <qstatusbar.h>
#include <qcombobox.h>
#include <qtoolbar.h>
#include <map>
#include "listmanager.h"
#include "playlistviewitem.h"
#include "playlistwrapper.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;

class playlistManager;

class playlistDialog : public QWidget
{ 
    Q_OBJECT

public:
    playlistDialog( QWidget * parent = 0, const char* name = 0);
    ~playlistDialog();

    void clearList();
    void addToList(const t_songInfo & item);
    void updateSelectedItem();

		 
protected slots:
    virtual void doubleClickOnList(QListViewItem*);
    virtual void searchTextUpdated(const QString &text);
    virtual void searchTextReturn();
    virtual void timedUpdate();
	virtual void guiUpdate();
    virtual void stopPressed();
	virtual void playPressed();
	virtual void nextPressed();
	virtual void prevPressed();
	virtual void pausePressed();
	virtual void randomToggle();

protected:
	QListView				   * playList;
    QComboBox 				   * searchComboBox;
    QLabel					   * searchTextLabel;
    QGridLayout		  		   * grid;
	playlistManager  		   & m_manager;
	QTimer 			 		   * m_timer;
	QStatusBar 		 		   * m_statusbar;
	QToolBar 		 		   * m_toolbar;
	map<int, playlistViewItem*>  m_itemlist;
	int							 m_currentlyPlaying;
	QPushButton				   * m_randomButton;

};

#endif // FORM1_H
