#ifndef XMLSTRING_H
#define XMLSTRING_H

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"

  typedef struct {
    int (*IsSpace)(PyObject *str);
    int (*SplitQName)(PyObject *qualifiedName, PyObject **prefix,
                      PyObject **localName);
  } XmlString_APIObject;

#ifndef XmlString_BUILDING_MODULE

/* --- C API ----------------------------------------------------*/

  static XmlString_APIObject *XmlString_API;

#define XmlString_IMPORT XmlString_API = \
    (XmlString_APIObject *) PyCObject_Import("Ft.Xml.Lib.XmlString", "CAPI")

#define XmlString_IsSpace XmlString_API->IsSpace
#define XmlString_SplitQName XmlString_API->SplitQName


#endif /* XmlString_BUILDING_MODULE */

#ifdef __cplusplus
}
#endif

#endif /* XMLSTRING_H */
