<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc rdf bbschema">
  <!-- don't exclude bb prefix -->

  <!--
File:  submit-purchase.xslt

Description:

    This stylesheet either saves shopping cart data as a new purchase,
    or deletes an existing purchase, depending on the form data that is
    passed in as top-level params.

    For a save/checkout operation, the shopping cart is retrieved from
    the user's session data, and a new purchase XML document is created
    in the repo, incorporating this data and some unit price data
    obtained from a Versa query.

    For a delete operation, the XML source document against which this
    stylesheet was applied is deleted from the repository, as long as
    it looks like it was a purchase XML document.

    This stylesheet can be applied to any XML source document, as long
    as the necessary form data comes in through the top-level params.

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:output method="xml"/>

  <xsl:param name="actionToDo"/>
  <xsl:param name="fres:uri-path"/>
  <xsl:param name="fres:absolute-path"/>

  <xsl:variable name="new-id" select="f:generate-uuid()"/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="not(fcore:has-session())">
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test='$actionToDo = "submit"'>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../purchase-summary.xslt"/>
            <xsl:call-template name="new"/>
          </xsl:when>
          <xsl:when test="$actionToDo = 'delete'">
            <fhttp:response-uri uri="{fhttp:local-path(bb:purchase/bb:customer/@id)}?xslt=../purchase-summary.xslt"/>
            <xsl:if test="/bb:purchase">
              <fcore:delete-resource/>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>There was an error. Expected $actionToDo to have a value of 'submit' or 'delete', not '</xsl:text>
            <xsl:value-of select="$actionToDo"/>
            <xsl:text>'.</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="new">

    <xsl:variable name='cur' select='fcore:session-data("CART")'/>

    <fcore:session-data key='CART'>
      <bb:pending date="{$cur/bb:pending/@date}">
        <xsl:copy-of select='$cur/bb:pending/bb:order[@cust-id != $fres:absolute-path]'/>
      </bb:pending>
    </fcore:session-data>

    <xsl:variable name='toSave-rtf'>
      <bb:pending date="{$cur/bb:pending/@date}">
        <xsl:copy-of select='$cur/bb:pending/bb:order[@cust-id = $fres:absolute-path]'/>
      </bb:pending>
    </xsl:variable>
    <xsl:variable name="toSave" select="exslt:node-set($toSave-rtf)"/>

    <xsl:variable name='date' select='$toSave/bb:pending/@date'/>
    <fcore:create-document path='{$new-id}' docdef='../purchase-dd'>
      <bb:purchase id="{$new-id}">
        <bb:date><xsl:value-of select="$date"/></bb:date>
        <bb:customer id="{$fres:absolute-path}"/>
        <xsl:for-each select='$toSave/bb:pending/bb:order'>
          <xsl:variable name="query">
              distribute(
                @'<xsl:value-of select="@prod-id"/>',
                '.-rdfs:label->*',
                '.-bbschema:units->*',
                '.-bbschema:price->*')
          </xsl:variable>
          <xsl:variable name="product-info" select="frdf:versa-query($query)"/>
          <bb:item>
            <bb:product id="{@prod-id}">
              <xsl:value-of select="string($product-info/List/List/List[1]/*[1])"/>
            </bb:product>
            <bb:quantity units="{string($product-info/List/List/List[2]/String[1])}">
              <xsl:value-of select="@qty"/>
            </bb:quantity>
            <bb:unitprice><xsl:value-of select="string($product-info/List/List/List[3]/*[1])"/></bb:unitprice>
          </bb:item>
        </xsl:for-each>
      </bb:purchase>
    </fcore:create-document>
  </xsl:template>

</xsl:stylesheet>
