########################################################################
#
# File Name: 	        TypeDefinition.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/TypeDefinition.py.html
#
"""
Implements the TypeDefinition meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Type
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class TypeDefinition(Type.Type):
    def __init__(self,db,data):
        Type.Type.__init__(self,db,data,MetaKind.mk_type_definition)


    def form_alias(self,target,inverse = 1):
        self._4ods_formRelationship('alias',Type.Type,'type_defs','add',target,inverse)

    def drop_alias(self,target,inverse = 1):
        self._4ods_dropRelationship('alias','type_defs','remove',target,inverse)

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getOdl(self,indent):
        if self.alias.meta_kind == MetaKind.mk_collection:
            return indent + 'typedef %s %s' % (self.alias._4ods_getOdl(''),self.name)
        else:
            return indent + 'typedef %s %s' % (self.alias.absolute_name(),self.name)

    def _4ods_getOdmgType(self):
        return self.alias._4ods_getOdmgType()

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)

        if self.alias.meta_kind == MetaKind.mk_collection:
            if self.alias not in found:
                found.append(self.alias)
        else:
            self.alias._4ods_getGeneratedMetaClasses(found,checked)

    def _4ods_findTypePath(self,object):
        if self.alias == object:
            return [self,object]
        res = self.alias._4ods_findTypePath(object)
        if res:
            return [self] + res
        return []



    _tupleNames = (('alias',),)

    _tupleDefinitions = {'alias':{td.TYPE:Constants.Types.ROBJECT,
                                  td.RELATIONSHIP:1,
                                  td.READONLY:1,
                                  },
                         }

    _localExtents = ()
