#!/usr/bin/perl -w

##############################################################################
#
#	dbswitch.pl	-	This program will copy the contents of one db 
#				backend to another.
#				Call it with dbswitch.pl olddriver newdriver
#
#	Author		-	Steve Kordik <countzero@cyberdeck.org>
#
#
##############################################################################

$olddriver = $ARGV[0];
$newdriver = $ARGV[1];

if (!$olddriver || !$newdriver) {
 print ("Usage: dbswitch.pl olddriver newdriver\n");
 exit;
}


use DBI;
use Gtk;
Gtk->init();
require 'prontolib.pl';
use Pronto::FirstRun;


$prefs{'DatabaseDriver'} = $olddriver;

$olddbh=&open_db_conn;

$prefs{'DatabaseDriver'} = $newdriver;

$conn=&open_db_conn;

&Pronto::FirstRun::create_database();

$sql =   "select id, msgid, boxid, accountid,
          date, sentto, sentfrom, subject, contenttype,
          contentxferencode, mimeversion, precedence,
          approvedby, inreplyto, replyto, listsub,
          listunsub, status, xorigip, cc, bcc, sender,
          returnpath, priority, xmailer, xuidl, xsender,
          localdate, newmsg, replyf, friendly, rreceiptto, score, ref, serverstat
	  from messages";
	  
$query=$olddbh->prepare($sql);
$query->execute();

$sql = "insert into messages (id, msgid, boxid, accountid,
          date, sentto, sentfrom, subject, contenttype,
          contentxferencode, mimeversion, precedence,
          approvedby, inreplyto, replyto, listsub,
          listunsub, status, xorigip, cc, bcc, sender,
          returnpath, priority, xmailer, xuidl, xsender,
          localdate, newmsg, replyf, friendly, rreceiptto, score, ref, serverstat)
	values
	(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
$query2=$conn->prepare($sql);
while (@row=$query->fetchrow_array()) {
 $query2->execute(@row);
}

$sql = "select id,uname,friendly,smtp,pop,pport,pass,reply,
	include,dm,def,type,dupecheck  from accounts";

$query=$olddbh->prepare($sql);
$query->execute();

$sql = "insert into accounts (id, uname, friendly, smtp,
          pop, pport, pass, reply, include,
          dm, def,type, dupecheck)
	values
	(?,?,?,?,?,?,?,?,?,?,?,?,?)";
$query2=$conn->prepare($sql);

while (@row=$query->fetchrow_array()) {
 $query2->execute(@row);
}

$sql = "select id,alias,address,public_key,groups from addresses";
$query=$olddbh->prepare($sql);
$query->execute();
$sql = "insert into addresses (id, alias, address, public_key, groups)
      values
	(?,?,?,?,?)";
$query2=$conn->prepare($sql);
while (@row=$query->fetchrow_array()) {
 if (!$row[4]) { $row[4] = " "; }
 $query2->execute(@row);
}

$sql = "select id, name from groups";
$query=$olddbh->prepare($sql);
$query->execute();
$sql = "insert into groups (id, name)
      values
	(?,?)";
$query2=$conn->prepare($sql);
while (@row=$query->fetchrow_array()) {
 $query2->execute(@row);
}


$sql = "select id,name,sibling,parent,query,body from boxlist";
$query=$olddbh->prepare($sql);
$query->execute();
$sql = "insert into boxlist (id, name, sibling, parent, query, body)
	values
	(?,?,?,?,?,?)";
$query2=$conn->prepare($sql);
while (@row=$query->fetchrow_array()) {
	if ($row[0] > 4) {
      	$query2->execute(@row);
	}
}
$sql = "select id,sorder,type,boxid,regex,addr,name,trueregex,count  from filters";
$query=$olddbh->prepare($sql);
$query->execute();
$sql = "insert into filters (id, sorder, type, boxid, regex, addr, name, trueregex, count)
	values
	(?,?,?,?,?,?,?,?,?)";
$query2=$conn->prepare($sql);
while (@row=$query->fetchrow_array()) {
	$query2->execute(@row);
}
