/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: node.cc,v $
 * Revision 1.1.1.1  2001/01/30 18:36:19  slash
 * Initial release.
 *
 */

#include "main.h"
#include "node.h"


//---------------------------------------------------------------------------
Node::Node()
{
    child_nodes_.clear();
}

//---------------------------------------------------------------------------
Node::~Node()
{
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        ZapPointer(child_nodes_[i]);
    }
    child_nodes_.clear();
}


//---------------------------------------------------------------------------
unsigned int Node::getLength() const
{
    unsigned int length = 0;

    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        length += child_nodes_[i]->getLength();
    }

    return length;
}
