/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: gridnode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:47  slash
 * Initial release.
 *
 */

#ifndef GRIDNODE_H
#define GRIDNODE_H

#include "environmentnode.h"

//---------------------------------------------------------------------------
/**
 * This class represents a grid-node.
 */
class GridNode : public EnvironmentNode {
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the grid-node.
     *
     * @param node A pointer to the grid-node in the XML-tree.
     */
    GridNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~GridNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * The integer-parameter will be passed to all sub-environments,
     * that should be written one-by-one-
     *
     * @param parameter The parameter, which will be passed through.
     */
    void writeHTML(int parameter) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;

    //-----------------------------------------------------------------------
    /**
     * This method signals, if the HTML-output of the grid should be stepped.
     *
     * @return 1, if the HTML-output should be stepped, else 0.
     *
     * @see getNumberOfHTMLSteps
     */
    int isHTMLStepped() const;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of steps of the HTML-output.
     *
     * @return The number of steps.
     */
    unsigned int getNumberOfHTMLSteps() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * The number of rows, the grid will have.
     * If -1, the rows-property was not given in the grid-markup.
     */
    int rows_;

    /**
     * The number of columns, the grid will have.
     * If -1, the columns-property was not given in the grid-markup.
     */
    int columns_;

    //-----------------------------------------------------------------------
    /**
     * 1, if the cells should be written one-by-one, else 0.
     * If -1, the step-property was not given in the grid-markup.
     */
    int step_;

    //-----------------------------------------------------------------------
    /**
     * The width of the border of the grid.
     * If -1, the border-property was not given in the grid-markup.
     */
    int border_;

    //-----------------------------------------------------------------------
    /**
     * The value of the table-attribute 'cellpadding' for the HTML-output.
     * If -1, the cellpadding-property was not given in the grid-markup.
     */
    int cellpadding_;

    //-----------------------------------------------------------------------
    /**
     * If 1, the grid-cells of the HTML-output will be as small as possible.
     * If -1, the contract-property was not given in the grid-markup.
     */
    int contract_;

    //-----------------------------------------------------------------------
    /**
     * 1, if the HTML-output of at least one sub-environment should be
     * stepped, else 0.
     */
    int subenvironment_step_;
};

#endif //GRIDNODE_H
