/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: authornode.cc,v $
 * Revision 1.5  2003/03/06 14:54:19  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.4  2003/02/26 12:28:33  benj
 * Clean up options a bit
 * Fix a crash when images are not found
 * Command option '-l' now has an optional argument
 * .tex files are now based on xml presentation name
 *
 * Revision 1.3  2003/02/18 12:56:49  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:22  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "authornode.h"


//---------------------------------------------------------------------------
AuthorNode::AuthorNode(xmlNodePtr node) : Node()
{
    // Extract the properties of the author-markup.
    name_  = (char*)xmlGetProp(node, (xmlChar*)"name");
    email_ = (char*)xmlGetProp(node, (xmlChar*)"email");
}

//---------------------------------------------------------------------------
AuthorNode::~AuthorNode()
{
}


//---------------------------------------------------------------------------
void AuthorNode::writeHTML(int parameter) const
{
    Output_ << "<P class=\"author\">"
            << "<A href=\"mailto:" << email_ << "\">" << name_ << "</A>"
            << "</P>" << std::endl;
}

//---------------------------------------------------------------------------
void AuthorNode::writeLaTeX() const
{
    if (!Parameters_.isOutlineEnabled()) {
        Output_ << "\\noindent" << std::endl;
    }
    Output_ << std::endl
	    << "{\\large "
	    << name_ << "\\\\" 
	    << std::endl
	    << "{\\tt <"
	    << email_
	    << ">}}" 
	    << std::endl;
}

//---------------------------------------------------------------------------
void AuthorNode::writeXML() const
{
    Output_ << "<author"
            << " name=\"" << name_ << "\""
            << " email=\"" << email_ << "\""
            << "/>" << std::endl;
}
