  /*  prefs-handlers.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"

#ifdef ZVT_USE_MATCHING

GtkWidget * label1, * label2, * label3, * label4;
GtkWidget * http_handler, * ftp_handler, * mail_handler, * telnet_handler;

int ApplyPrefsHandlers ()
{
  strcpy (Prefs.http_handler, gtk_entry_get_text (GTK_ENTRY(http_handler)));
  strcpy (Prefs.ftp_handler, gtk_entry_get_text (GTK_ENTRY(ftp_handler)));
  strcpy (Prefs.mail_handler, gtk_entry_get_text (GTK_ENTRY(mail_handler)));
  strcpy (Prefs.telnet_handler, gtk_entry_get_text (GTK_ENTRY(telnet_handler)));

}

int CreatePrefsHandlers (GtkContainer * area)
{

  GtkWidget * hbox1, * vbox1, * vbox2;

  hbox1 = gtk_hbox_new (FALSE, 1);
  vbox1 = gtk_vbox_new (FALSE, 1);
  vbox2 = gtk_vbox_new (FALSE, 1);

  gtk_box_pack_start (GTK_BOX(area), hbox1, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hbox1), GTK_WIDGET(vbox1), TRUE,FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hbox1), vbox2, TRUE, FALSE, 0);


  label1 = gtk_label_new ("HTTP Handler");
  label2 = gtk_label_new ("FTP Handler");
  label3 = gtk_label_new ("Mail Handler");
  label4 = gtk_label_new ("Telnet Handler");
  
  http_handler = gtk_entry_new ();
  ftp_handler = gtk_entry_new ();
  mail_handler = gtk_entry_new ();
  telnet_handler = gtk_entry_new ();


  gtk_box_pack_start (GTK_BOX(vbox1), label1, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox1), label2, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox1), label3, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox1), label4, TRUE, FALSE, 0);
  
  gtk_box_pack_start (GTK_BOX(vbox2), http_handler, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox2), ftp_handler, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox2), mail_handler, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox2), telnet_handler, TRUE, FALSE, 0);

  gtk_entry_set_text (GTK_ENTRY(http_handler), Prefs.http_handler);
  gtk_entry_set_text (GTK_ENTRY(ftp_handler), Prefs.ftp_handler);
  gtk_entry_set_text (GTK_ENTRY(mail_handler), Prefs.mail_handler);
  gtk_entry_set_text (GTK_ENTRY(telnet_handler), Prefs.telnet_handler);


  gtk_signal_connect_object (GTK_OBJECT(http_handler), "changed", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(area));
  gtk_signal_connect_object (GTK_OBJECT(ftp_handler), "changed", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(area));
  gtk_signal_connect_object (GTK_OBJECT(mail_handler), "changed", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(area));
  gtk_signal_connect_object (GTK_OBJECT(telnet_handler), "changed", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(area));

}




#endif
#ifndef ZVT_USE_MATCHING

int ApplyPrefsHandlers()
{}
int CreatePrefsHandlers(GtkContainer * area)
{}

#endif
