/*
SendMSG.cc
*/

#include "SendMSG.h"
extern Language *L;
extern STRINGDRIVER file_string;

//For avoid a Microsoft Bug in Outlook XP
//  http://www.washington.edu/pine/pine-info/2002.04/msg00042.html
#define AVOID_MS_BUG

SendMSG::SendMSG (const char *aserver, const char *flname, UserOptions *auo, const char *adefaulthost, 
                  CCLIENT *acclient)
  {
  int cont, size, numlineas, ll;
  FILE *fr;
  TBuffer linea;
  
  cclient = acclient;
  uo = auo;
  xstrncpy (localhost, CMAXIPNAME, mylocalhost());
  xstrncpy (user, CMAXBUFFER, auo->getUsername());
  xstrncpy (defaulthost, CMAXIPNAME, adefaulthost);
  xstrncpy (server, CMAXIPNAME, aserver);
  UseSMTPAuthenticated = auo->getAuthSMTP();
  initStr (to);
  initStr (newsgroups);
  initStr (from);
  initStr (cc);
  initStr (bcc);
  initStr (subject);
  initStr (references);
  initStr (trueemail);
  firsttext = NULL;
  setPERSONALNAME (auo->getPersonalName());
  if (!IsEmpty(auo->getTrueEmail())) {setTRUEEMAIL (auo->getTrueEmail());}
  fr = fopen (flname, "r");
  fgets (linea, CMAXBUFFER, fr); QuitaRetornoCarroDeLinea (linea); 
         savemsginsentmail = xatoidef (linea, 0);
  fgets (linea, CMAXBUFFER, fr); QuitaRetornoCarroDeLinea (linea); setTO (linea); setNNTPGROUPS (linea);
  fgets (linea, CMAXBUFFER, fr); QuitaRetornoCarroDeLinea (linea); setCC (linea);
  fgets (linea, CMAXBUFFER, fr); QuitaRetornoCarroDeLinea (linea); setBCC (linea);
  fgets (linea, CMAXBUFFER, fr); QuitaRetornoCarroDeLinea (linea); setSUBJECT (linea);
  fgets (linea, CMAXBUFFER, fr); QuitaRetornoCarroDeLinea (linea); setFROM (linea);
  size = 0; cont = 0; numlineas = 0;
  while (fgets (linea, CMAXBUFFER, fr) != NULL)
    {
    ++numlineas;
    
    //Bare newlines handling
    if (strstr (linea, "\r\n")    != NULL) {/*NOTHING*/}
    else if (strstr (linea, "\r") != NULL) {xstrncat (linea, CMAXBUFFER, "\n");}
    else if (strstr (linea, "\n") != NULL) {ll = strlen(linea); linea[ll - 1]='\r'; linea[ll]='\n'; linea[ll + 1]='\0';}
    else {xstrncat (linea, CMAXBUFFER, "\r\n");};
    
    size += strlen (linea) + 1;
    firsttext = (char *) realloc (firsttext, size);
    if (cont == 0) xstrncpy (firsttext, size, linea); 
    else xstrncat (firsttext, size, linea);
    ++cont;
    initStr (linea);
    }
  fclose (fr);
  //if (numlineas == 1) QuitaRetornoCarroDeLinea (firsttext);
  Quoted = IsQuotedPrintable (firsttext);
  }  
  
SendMSG::~SendMSG ()
  {
  }  

bool SendMSG::getMustSaveMsgSentmail (void)
  {
  return savemsginsentmail;
  }    

const char *SendMSG::MakeBoundary (void)
  {           
  int i, p;
  TNumber anum;
  BOUNDARY[0] = '\0';                           
  for (i = 0; i < LENGTHBOUNDARY; ++i)
    {
    p = (int)Rand (9);
    xstrncat (BOUNDARY, SIZEBOUNDARY, xitoa(p, anum));
    }
  return BOUNDARY;
  }
  
const char *SendMSG::MakeMidBoundary (const char *boundary)
  {
  xstrncpy (BOUNDARY, SIZEBOUNDARY, "--"); 
  xstrncat (BOUNDARY, SIZEBOUNDARY, boundary);
  return BOUNDARY;
  }

const char *SendMSG::MakeEndBoundary (const char *boundary)
  {
  xstrncpy (BOUNDARY, SIZEBOUNDARY, "--"); 
  xstrncat (BOUNDARY, SIZEBOUNDARY, boundary);
  xstrncat (BOUNDARY, SIZEBOUNDARY, "--");
  return BOUNDARY;  
  }

const char *SendMSG::MakeContentID (const char *user, const char *maildomain)
  {
  int i, p;
  TNumber anum;
  xstrncpy (BOUNDARY, SIZEBOUNDARY, "<");
  for (i = 0; i < 10; ++i)
    {
    p = (int)Rand (9);
    xstrncat (BOUNDARY, SIZEBOUNDARY, xitoa(p, anum));
    }
  xstrncat (BOUNDARY, SIZEBOUNDARY, user);
  xstrncat (BOUNDARY, SIZEBOUNDARY, "@");
  xstrncat (BOUNDARY, SIZEBOUNDARY, maildomain);
  xstrncat (BOUNDARY, SIZEBOUNDARY, ">");
  return BOUNDARY;    
  }

void SendMSG::setTO (const char *ato)
  {
  initStr (to);
  if (ato != NULL) xstrncpy (to, CMAXBUFFER, ato);
  }

void SendMSG::setNNTPGROUPS  (const char *anewsgroups)
  {
  initStr (newsgroups);  
  if (anewsgroups != NULL) 
    {
    if (NCstrstr (anewsgroups, NNTPFOLDERPREFIX) == 1)
      {
      //#local.a   -->  local.a
      xstrncpy (newsgroups, CMAXBUFFER, anewsgroups);
      memmove (newsgroups, newsgroups + strlen (NNTPFOLDERPREFIX), strlen (newsgroups) - strlen(NNTPFOLDERPREFIX) + 1);
      }
    else
      {
      xstrncpy (newsgroups, CMAXBUFFER, anewsgroups);
      }
    }
  }
  
void SendMSG::setFROM  (const char *afrom)
  {
  initStr (from);
  if (afrom != NULL) xstrncpy (from, CMAXBUFFER, afrom);
  }

void SendMSG::setCC  (const char *acc)
  {
  initStr (cc);
  if ((acc != NULL) && (IsEmpty(acc) == false)) xstrncpy (cc, CMAXBUFFER, acc);
  }

void SendMSG::setBCC  (const char *abcc)
  {
  initStr (bcc);
  if ((abcc != NULL) && (IsEmpty(abcc) == false)) xstrncpy (bcc , CMAXBUFFER, abcc);
  }

void SendMSG::setSUBJECT  (const char *asubject)
  {
  initStr (subject);
  if (asubject != NULL) xstrncpy (subject, CMAXBUFFER, asubject);
  }         
 
void SendMSG::setPERSONALNAME  (const char *apersonalname)
  {
  initStr (personalname);
  if (apersonalname != NULL) xstrncpy (personalname, CMAXBUFFER, apersonalname);
  }  
  
void SendMSG::setFIRSTTEXT  (const char *afirsttext)
  {
  if (afirsttext != NULL) firsttext = xstrdup (afirsttext);
  else firsttext = xstrdup (" ");;  
  }
    
void SendMSG::setREFERENCES  (const char *areferences)
  {
  initStr (references);
  if (areferences != NULL) xstrncpy (references, CMAXBUFFER, areferences);
  }      

void SendMSG::setTRUEEMAIL  (const char *atrueemail)
  {
  initStr (trueemail);
  if (atrueemail != NULL) xstrncpy (trueemail, CMAXBUFFER, atrueemail);
  }         
    
char *SendMSG::getTO (void) {return to;}
char *SendMSG::getNNTPGROUPS (void) {return newsgroups;}
char *SendMSG::getFROM (void) {return from;}
char *SendMSG::getCC (void) {return cc;} 
char *SendMSG::getBCC (void) {return bcc;}
char *SendMSG::getSUBJECT (void) {return subject;}          
char *SendMSG::getPERSONALNAME (void) {return personalname;}          
char *SendMSG::getFIRSTTEXT (void) {return firsttext;}    
char *SendMSG::getREFERENCES (void) {return references;}          
char *SendMSG::getTRUEEMAIL (void) {return trueemail;}          

void SendMSG::DelAttachs (void)
  {
  uo->delAllAttachs();
  //DelAllFilesFromDir ((char *)uo->getAttachDir());
  }
        
bool SendMSG::sendSMTP  (TBuffer errormsg, const char *sentmail, bool *createdsentmailfolder, const char *fnmailcap)
  {
  TBuffer abuf;
  TFileName fntmp;           
    
  *createdsentmailfolder = false;
  initStr (errormsg);  
  if (IsEmpty (to))     {xstrncpy (errormsg, CMAXBUFFER, L->get(MSG_FIELD_TO_EMPTY)); return false;}
  if (IsEmpty(subject)) {xstrncpy (errormsg, CMAXBUFFER, L->get(MSG_FIELD_SUBJ_EMPTY)); return false;}
  /*
  HELO <MIHOSTNAME>
  MAIL FROM: <SENDER>
  RCPT TO: <RECIPIENT>
  DATA
  ......
  .
  QUIT
  */
  TBuffer base64;
  XString XS;
  int cod, base64len;
  TBuffer buffer, basura, stcod, stsep;
  IPNAME MailDomain;
  XSocket *smtpsocket;
  int sock;
  bool HAYADJUNTOS = false, TrueAuth = false;
           
  xstrncpy (MailDomain, CMAXIPNAME, uo->getMailDomain());
  smtpsocket = new XSocket ();
  smtpsocket->ignore_pipe();
  sock = smtpsocket->do_client_inet (server, NULL, DEFSMTPPORT, 240);
  if (sock == -1) {xstrncpy (errormsg, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  smtpsocket->SetSock (sock);
  /*LEO LA LINEA DE BIENVENIDA*/
  /*-1 by the possible buffer overflow resulting from the linefeed added below. */
  if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;}
  sscanf (buffer, "%d %2000s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}

  /*ENVIO HELO o EHLO*/
  //   for SMTP authentication. 0=No,1=Must,2=Try  
  if ((UseSMTPAuthenticated == 1) || (UseSMTPAuthenticated == 2))
    {
    snprintf (buffer, CMAXBUFFER, "EHLO %s\n", localhost);
    }
  else
    {                                
    snprintf (buffer, CMAXBUFFER, "HELO %s\n", localhost);
    }
  if (smtpsocket->Puts (buffer) == -1) {return false;}

  do
    {
    /*LEO LA LINEAS DEVUELTAS*/
    if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
    XS = XString (buffer);
    xstrncpy (stcod,  CMAXBUFFER, XS.substring (0, 3).cstr());
    xstrncpy (stsep,  CMAXBUFFER, XS.substring (3, 4).cstr());
    xstrncpy (basura, CMAXBUFFER, XS.substring (4).cstr());
    cod = xatoidef (stcod, 500);
    if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
    }
  while (strcmp (stsep, "-") == 0);

  TrueAuth = false;
  if ((UseSMTPAuthenticated == 1) || (UseSMTPAuthenticated == 2))
    {
    char *pc;
    int totsz;
    /*\000username\000password*/
    memset (abuf, 0, CMAXBUFFER);
    pc = abuf + 1;
    memcpy (pc, cclient->getUsername(), strlen(cclient->getUsername()));
    pc = abuf + strlen(cclient->getUsername()) + 2;
    memcpy (pc, cclient->getPassword(), strlen(cclient->getPassword()));
    totsz = strlen(cclient->getUsername()) + strlen(cclient->getPassword()) + 2;

    EncodeBase64Buffer (abuf, totsz, base64, &base64len);

    /*ENVIO AUTH PLAIN*/
    snprintf (buffer, CMAXBUFFER, "auth plain %s\n", base64);
    //DEBUG ("--%s--", buffer);
    if (smtpsocket->Puts (buffer) == -1) {return false;}

    /*LEO LA LINEA DE AUTH PLAIN*/
    if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
    sscanf (buffer, "%d %2000s", &cod, basura);
    if (cod != 235) 
      {
      TrueAuth = false;
      //Send must be authenticated
      if (UseSMTPAuthenticated == 1)
        {
        LOG ("Error authenticating user=%s, SMTP server=%s, Postman does NOT send this mail.",
             user, server);
        xstrncpy (errormsg, CMAXBUFFER, buffer); 
        return false;
        }
      else
        {
        LOG ("Error authenticating user=%s, SMTP server=%s, Postman will send this mail without authentication.",
             user, server);
        }
      }
    else
      {
      TrueAuth = true;
      }  
    }

  /*ENVIO MAIL FROM*/
  snprintf (buffer, CMAXBUFFER, "MAIL FROM: %s@%s\n", user, MailDomain);
  if (smtpsocket->Puts (buffer) == -1) {return false;}
    
  /*LEO LA LINEA DE MAIL FROM*/
  if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
  sscanf (buffer, "%d %2000s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
  
  /*ENVIO RCPT*/
  ExtraeAddresses (&SLTO,  to, true);
  ExtraeAddresses (&SLCC,  cc, true);
  ExtraeAddresses (&SLBCC, bcc, true);
  for (int k = 0; k < SLTO.Count(); ++k)
    {
    snprintf (buffer, CMAXBUFFER, "RCPT TO: %s\n", SLTO.getString(k).cstr());
    if (smtpsocket->Puts (buffer) == -1) {return false;}
    /*LEO LA LINEA DE RCPT*/
    if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
    sscanf (buffer, "%d %2000s", &cod, basura);
    if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
    }
  for (int h = 0; h < SLCC.Count(); ++h)
    {
    snprintf (buffer, CMAXBUFFER, "RCPT TO: %s\n", SLCC.getString(h).cstr());
    if (smtpsocket->Puts (buffer) == -1) {return false;}
    /*LEO LA LINEA DE RCPT*/
    if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
    sscanf (buffer, "%d %2000s", &cod, basura);
    if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
    }    
  for (int m = 0; m < SLBCC.Count(); ++m)
    {
    snprintf (buffer, CMAXBUFFER, "RCPT TO: %s\n", SLBCC.getString(m).cstr());
    if (smtpsocket->Puts (buffer) == -1) {return false;}
    /*LEO LA LINEA DE RCPT*/
    if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
    sscanf (buffer, "%d %2000s", &cod, basura);
    if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
    }    
          
  /*ENVIO DATA*/
  snprintf (buffer, CMAXBUFFER, "DATA\n");
  if (smtpsocket->Puts (buffer) == -1) {return false;}
  /*LEO LA LINEA DE DATA*/
  if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
  sscanf (buffer, "%d %2000s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
  
  /*METO MIS DATOS*/
  LINEA BOUNDARY, MIDBOUNDARY, ENDBOUNDARY;
  xstrncpy (BOUNDARY, LENGTHBOUNDARY + 10, MakeBoundary ());
  xstrncpy (MIDBOUNDARY, LENGTHBOUNDARY + 10, MakeMidBoundary (BOUNDARY));
  xstrncpy (ENDBOUNDARY, LENGTHBOUNDARY + 10, MakeEndBoundary (BOUNDARY));
      
  MakeTmpName (fntmp, CMAXFILENAME);

  FILE *FW;
  FW = fopen (fntmp, "w");
                      
  if (!IsEmpty(getTRUEEMAIL()))
    {
    if (IsEmpty (personalname)) {XS = "<"; XS += getTRUEEMAIL();}
    else {XS = "\""; XS += personalname; XS += "\"<"; XS += getTRUEEMAIL();}
    XS += ">";
    }
  else
    {  
    if (IsEmpty (personalname)) {XS = "<"; XS += user;}
    else {XS = "\""; XS += personalname; XS += "\"<"; XS += user;}
    if (!IsEmpty (MailDomain)) {XS += "@"; XS += MailDomain;}
    XS += ">";
    }
    
  //From: line
  if ((USERCANCHANGEFROM == 1) && (from != NULL))
    {
    fprintf (FW, "From: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)from));
    }
  else
    {  
    fprintf (FW, "From: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)XS.cstr()));
    }

  fprintf (FW, "To: %s\r\n", to);
  if (IsEmpty(cc) == false)      
    {fprintf (FW, "Cc: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)cc));}
  if (IsEmpty(bcc) == false)     
    {fprintf (FW, "Bcc: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)bcc));}    
  if (IsEmpty(subject) == false) 
    {fprintf (FW, "Subject: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)subject));}
  
  //Date: Mon, 8 Sep 1997 15:06:16 +0200 (GMT)
  rfc822_date (abuf);
  fprintf (FW, "Date: %s\r\n", abuf);
  fprintf (FW, "X-Real-Sender: %s@%s\r\n", user, MailDomain);
  fprintf (FW, "X-Postman-SMTP-Auth: %d,%d\r\n", UseSMTPAuthenticated, TrueAuth);  
  fprintf (FW, "X-Mailer: %s\r\n", XMAILER);
  if (!IsEmpty (references)) {fprintf (FW, "References: %s\r\nIn-reply-to: %s\r\n", references, references);}
  fprintf (FW, "MIME-Version: 1.0\r\n");
  if (uo->numAttachs() > 0)  
    {
    HAYADJUNTOS = true;
    fprintf (FW, "Content-Type: multipart/mixed;\r\n\tboundary=\"%s\"\r\n", BOUNDARY);
    }
  else
    {  
    HAYADJUNTOS = false;
    fprintf (FW, "Content-Type: text/plain;\r\n\tcharset=\"%s\"\r\n", THECHARSET);
    if (Quoted == true) fprintf (FW, "Content-Transfer-Encoding: quoted-printable\r\n");
    }
  fprintf (FW, "Message-ID: %s\r\n", MakeContentID (user, MailDomain));
  fprintf (FW, "\r\n");   
  
  if (HAYADJUNTOS == true)
    {
    fprintf (FW, "This message is in MIME format.  The first part should be readable text,\r\n");
    fprintf (FW, "while the remaining parts are likely unreadable without MIME-aware tools.\r\n"); 
    fprintf (FW, "\r\n");
    }
  
  char *fntmpquoted;
  //LOG ("firsttext='%s'", firsttext);
  fntmpquoted = ToQuotedPrintableFile (firsttext);
  //LOG ("fntmpquoted=%s", fntmpquoted);
  LINEA linea;
  FILE *FR;
  if (HAYADJUNTOS == false)
    {
    FR = fopen (fntmpquoted, "r");
    initStr (linea);
    while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
      {
      if (strcmp (linea, "") != 0) 
        {
        fprintf (FW, "%s", linea);      
        }
      initStr (linea);
      }
    fclose (FR);
    //LOG ("--%s--", fntmpquoted);
    DeleteFile (fntmpquoted);
    }
  else
    { 
    fprintf (FW, "\r\n%s\r\n", MIDBOUNDARY);
    fprintf (FW, "Content-Type: text/plain;\r\n\tcharset=\"%s\"\r\n", THECHARSET);
    if (Quoted == true) fprintf (FW, "Content-Transfer-Encoding: quoted-printable\r\n");
    fprintf (FW, "\r\n");
    FR = fopen (fntmpquoted, "r");
    initStr (linea);
    while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
      {
      if (strcmp (linea, "") != 0) fprintf (FW, "%s", linea);      
      initStr (linea);
      }
    fclose (FR); 
    DeleteFile (fntmpquoted);   
    int i;
    i = 0;       
    while ((i < uo->numAttachs()) && (i < MAXNUMATTACHSINSEND))
      {
      //ESCRIBO EL PRIMER ADJUNTO
      LINEA truefn, CT;
      TSBuffer basura;
      initStr(basura);
      xstrncpy (truefn, MAXLENGTHLINE, uo->getTrueFileNameAttach(i));
      if (FileExists (truefn) == true)
        {
        xstrncpy (CT, MAXLENGTHLINE, getMailcapTipoFromFilename (truefn, fnmailcap));
        if (strcmp (CT, "") == 0) 
          {
          sscanf (uo->getAttachInfo(i), "%500s %2000[^]]s", CT, basura);
          if (CT[strlen(CT) - 1] == ',') {CT[strlen(CT) - 1] = '\0';}
          if ((strcmp (CT, "") == 0) || (strcmp (CT, "\"\",") == 0))
            {
            xstrncpy (CT, MAXLENGTHLINE, "APPLICATION/OCTET-STREAM");
            }
          }
        fprintf (FW, "\r\n%s\r\n", MIDBOUNDARY);
#ifndef AVOID_MS_BUG
        fprintf (FW, "Content-ID: %s\r\n", MakeContentID (user, MailDomain));
#endif
        fprintf (FW, "Content-Type: %s;\r\n\tname=\"%s\"\r\n", CT, uo->getFileNameAttach(i));
        fprintf (FW, "Content-Description: %s\r\n", basura);
        fprintf (FW, "Content-Disposition: attachment;\r\n\tfilename=\"%s\"\r\n", uo->getFileNameAttach(i));
        //NON CODED MESSAGE/RFC822
        bool IsMessageRFC822;
        IsMessageRFC822 = false;
        if (strstr (CT, "MESSAGE/RFC822") != NULL) IsMessageRFC822 = true;
        if (IsMessageRFC822 == false) fprintf (FW, "Content-Transfer-Encoding: BASE64\r\n");
        fprintf (FW, "\r\n");
        int szfn = FileSize (truefn);
        if (IsMessageRFC822 == false)
          { 
          FR = fopen (truefn, "r");
          EncodeBase64File (FR, FW, szfn);
          fclose (FR);
          }
        else
          {
          FR = fopen (truefn, "r");
          initStr (linea);
          while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
            {
            if (strcmp (linea, "") != 0) fprintf (FW, "%s", linea);      
            initStr (linea);
            }
          fclose (FR);
          }
        }
      ++i;
      }
    fprintf (FW, "\r\n%s\r\n", ENDBOUNDARY);
    }  
  fclose (FW);  
  
  //GUARDO PRIMERO EN LA CARPETA SENTMAIL
  if ((savemsginsentmail) && (cclient != NULL)) 
    {
    bool bo;
    STRING stmsg;
    int sz;
    TBuffer SentMailBox, abuf;
    
    //SentMailBox = uo->getMailboxPrefix();
    //SentMailBox += sentmail;
    //LOG ("SentMailBox=%s", (char *)SentMailBox.cstr());
    xstrncpy (SentMailBox, CMAXBUFFER, cclient->expandMailboxName (sentmail, abuf));
    //LOG ("SentMailBox=%s", SentMailBox);    
        
    sz = FileSize (fntmp);
    FR = fopen (fntmp, "r");
    INIT (&stmsg, file_string, (void *)FR, sz);
    bo = cclient->appendMsg (SentMailBox, &stmsg);
    if (!bo)
      {      
      bo = cclient->createMailbox (SentMailBox);
      if (bo) 
        {      
        *createdsentmailfolder = true;
        INIT (&stmsg, file_string, (void *)FR, sz);
        bool bx;
        bx = cclient->appendMsg(SentMailBox, &stmsg);
        if (bx == false)
          {
          xstrncpy (errormsg, CMAXBUFFER, "Can not save msg in sent mail");
          }
        }
      else
        {
        xstrncpy (errormsg, CMAXBUFFER, "Can not save msg in sent mail");
        }  
      }
    fclose (FR); 
    }

  //ENVIO YA EL FICHERO POR SMTP
  FR = fopen (fntmp, "r");
  initStr (linea);
  while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
    {
    if (strcmp (linea, "") != 0) 
      {
      if (strcmp (linea, ".\n") == 0) {xstrncpy (linea, MAXLENGTHLINE, " .\n");}
      if (strcmp (linea, ".\015\012") == 0) {xstrncpy (linea, MAXLENGTHLINE, " .\n");}        
      if (smtpsocket->Puts (linea) == -1) {fclose (FR); DeleteFile (fntmp); return false;}    
      }
    initStr (linea);
    }
  fclose (FR);
  
  snprintf (buffer, CMAXBUFFER, "\r\n.\r\n");
  if (smtpsocket->Puts (buffer) == -1) {fclose (FR); DeleteFile (fntmp); return false;}
  
  /*LEO LA LINEA DE ACEPTACION DE DATOS*/
  if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {fclose (FR); DeleteFile (fntmp); return false;}
  sscanf (buffer, "%d %2000s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {fclose (FR); DeleteFile (fntmp); return false;}
  
  /*ENVIO QUIT*/
  snprintf (buffer, CMAXBUFFER, "QUIT\n");
  if (smtpsocket->Puts (buffer) == -1) {fclose (FR); DeleteFile (fntmp); return false;}
  /*LEO LA LINEA DE QUIT*/
  if (!smtpsocket->Gets (buffer, sizeof(buffer) -1)) {fclose (FR); DeleteFile (fntmp); return false;}
  sscanf (buffer, "%d %2000s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {fclose (FR); DeleteFile (fntmp); return false;}
  
  DeleteFile (fntmp);
  //LOG ("--%s--", fntmp);
  
  delete smtpsocket;
  return true;
  }                 
        
bool SendMSG::sendNNTP  (TBuffer errormsg, const char *sentmail, bool *createdsentmailfolder, const char *fnmailcap)
  {
  TBuffer abuf;
  XString XS;    

  *createdsentmailfolder = false;
  initStr (errormsg);  
  if (IsEmpty (newsgroups)) {xstrncpy (errormsg, CMAXBUFFER, L->get(MSG_FIELD_TO_EMPTY)); return false;}
  if (IsEmpty(subject))     {xstrncpy (errormsg, CMAXBUFFER, L->get(MSG_FIELD_SUBJ_EMPTY)); return false;}

  /*Conversation Example
  200 news.uv.es InterNetNews NNRP server INN 2.1 24-Jul-1998 ready (posting ok).
  POST
  340 Ok
  From: pp@uv.es
  NewsGroups: local.a
  Subject: Testing.
  
  That
  .
  240 Article posted.
  QUIT
  205 .
  Connection closed by foreign host.
  */
  
  int cod;
  TBuffer buffer, basura;
  IPNAME MailDomain;
  XSocket *nntpsocket;
  int sock;
  bool HAYADJUNTOS = false;
  TFileName fntmp;         
           
  xstrncpy (MailDomain, CMAXIPNAME, uo->getMailDomain());
  nntpsocket = new XSocket ();
  nntpsocket->ignore_pipe();
  sock = nntpsocket->do_client_inet (server, NULL, DEFNNTPPORT, 240);
  if (sock == -1) {xstrncpy (errormsg, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  nntpsocket->SetSock (sock);
  /*LEO LA LINEA DE BIENVENIDA*/
  /*-1 by the possible buffer overflow resulting from the linefeed added below. */
  if (!nntpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;}
  sscanf (buffer, "%d %2000s", &cod, basura);
  if (cod != 200) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}

  /*ENVIO POST*/
  snprintf (buffer, CMAXBUFFER, "Post\n");
  if (nntpsocket->Puts (buffer) == -1) {return false;}
  /*LEO LA LINEA DEVUELTA*/
  if (!nntpsocket->Gets (buffer, sizeof(buffer) -1)) {return false;} 
  sscanf (buffer, "%d %2000s", &cod, basura);
  if (cod != 340) {xstrncpy (errormsg, CMAXBUFFER, buffer); return false;}
  
  /*METO MIS DATOS*/
  LINEA BOUNDARY, MIDBOUNDARY, ENDBOUNDARY;
  xstrncpy (BOUNDARY, LENGTHBOUNDARY + 10, MakeBoundary ());
  xstrncpy (MIDBOUNDARY, LENGTHBOUNDARY + 10, MakeMidBoundary (BOUNDARY));
  xstrncpy (ENDBOUNDARY, LENGTHBOUNDARY + 10, MakeEndBoundary (BOUNDARY));
      
  MakeTmpName (fntmp, CMAXFILENAME);

  FILE *FW;
  FW = fopen (fntmp, "w");
  
  if (!IsEmpty(getTRUEEMAIL()))
    {
    if (IsEmpty (personalname)) {XS = "<"; XS += getTRUEEMAIL();}
    else {XS = "\""; XS += personalname; XS += "\"<"; XS += getTRUEEMAIL();}
    XS += ">";
    }
  else
    {  
    if (IsEmpty (personalname)) {XS = "<"; XS += user;}
    else {XS = "\""; XS += personalname; XS += "\"<"; XS += user;}
    if (!IsEmpty (MailDomain)) {XS += "@"; XS += MailDomain;}
    XS += ">";
    }
  
  //From: line
  if ((USERCANCHANGEFROM == 1) && (from != NULL))
    {
    fprintf (FW, "From: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)from));
    }
  else
    {  
    fprintf (FW, "From: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)XS.cstr()));
    }

  if (IsEmpty(subject) == false) 
    {fprintf (FW, "Subject: %s\r\n", (char *)CodificaHeaderQuotedP_One2One((xuchar *)subject));}
  
  //Date: Mon, 8 Sep 1997 15:06:16 +0200 (GMT)
  rfc822_date (abuf);
  fprintf (FW, "NewsGroups: %s\r\n", newsgroups);
  fprintf (FW, "To: #%s\r\n", newsgroups);
  fprintf (FW, "Date: %s\r\n", abuf);
  fprintf (FW, "X-Real-Sender: %s@%s\r\n", user, MailDomain);
  fprintf (FW, "X-Mailer: %s\r\n", XMAILER);
  if (!IsEmpty (references)) {fprintf (FW, "References: %s\r\nIn-reply-to: %s\r\n", references, references);}
  fprintf (FW, "X-Newsreader: %s\r\n", XMAILER);  
  fprintf (FW, "MIME-Version: 1.0\r\n");
  if (uo->numAttachs() > 0)  
    {
    HAYADJUNTOS = true;
    fprintf (FW, "Content-Type: multipart/mixed;\r\n\tboundary=\"%s\"\r\n", BOUNDARY);
    }
  else
    {  
    HAYADJUNTOS = false;
    fprintf (FW, "Content-Type: text/plain;\r\n\tcharset=\"%s\"\r\n", THECHARSET);
    if (Quoted == true) fprintf (FW, "Content-Transfer-Encoding: quoted-printable\r\n");
    }
  fprintf (FW, "Message-ID: %s\r\n", MakeContentID (user, MailDomain));   
  fprintf (FW, "\r\n");

  
  if (HAYADJUNTOS == true)
    {
    fprintf (FW, "This message is in MIME format.  The first part should be readable text,\r\n");
    fprintf (FW, "while the remaining parts are likely unreadable without MIME-aware tools.\r\n"); 
    fprintf (FW, "\r\n");
    }
  
  char *fntmpquoted;
  //LOG ("firsttext='%s'", firsttext);
  fntmpquoted = ToQuotedPrintableFile (firsttext);
  //LOG ("fntmpquoted=%s", fntmpquoted);
  LINEA linea;
  FILE *FR;
  if (HAYADJUNTOS == false)
    {
    FR = fopen (fntmpquoted, "r");
    initStr (linea);
    while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
      {
      if (strcmp (linea, "") != 0) 
        {
        fprintf (FW, "%s", linea);      
        }
      initStr (linea);
      }
    fclose (FR);
    DeleteFile (fntmpquoted);
    }
  else
    { 
    fprintf (FW, "\r\n%s\r\n", MIDBOUNDARY);
    fprintf (FW, "Content-Type: text/plain;\r\n\tcharset=\"%s\"\r\n", THECHARSET);
    if (Quoted == true) fprintf (FW, "Content-Transfer-Encoding: quoted-printable\r\n");
    fprintf (FW, "\r\n");
    FR = fopen (fntmpquoted, "r");
    initStr (linea);
    while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
      {
      if (strcmp (linea, "") != 0) fprintf (FW, "%s", linea);      
      initStr (linea);
      }
    fclose (FR); 
    DeleteFile (fntmpquoted);   
    int i;
    i = 0;       
    while ((i < uo->numAttachs()) && (i < MAXNUMATTACHSINSEND))
      {
      //ESCRIBO EL PRIMER ADJUNTO
      LINEA truefn, CT;
      TSBuffer basura;
      initStr(basura);
      xstrncpy (truefn, MAXLENGTHLINE, uo->getTrueFileNameAttach(i));
      if (FileExists (truefn) == true)
        {
        xstrncpy (CT, MAXLENGTHLINE, getMailcapTipoFromFilename (truefn, fnmailcap));
        if (strcmp (CT, "") == 0) 
          {
          sscanf (uo->getAttachInfo(i), "%500s %2000[^]]s", CT, basura);
          if (CT[strlen(CT) - 1] == ',') {CT[strlen(CT) - 1] = '\0';}
          if ((strcmp (CT, "") == 0) || (strcmp (CT, "\"\",") == 0))
            {
            xstrncpy (CT, MAXLENGTHLINE, "APPLICATION/OCTET-STREAM");
            }
          }
        fprintf (FW, "\r\n%s\r\n", MIDBOUNDARY);
#ifndef AVOID_MS_BUG
        fprintf (FW, "Content-ID: %s\r\n", MakeContentID (user, MailDomain));
#endif
        fprintf (FW, "Content-Type: %s;\r\n\tname=\"%s\"\r\n", CT, uo->getFileNameAttach(i));
        fprintf (FW, "Content-Description: %s\r\n", basura);
        fprintf (FW, "Content-Disposition: attachment;\r\n\tfilename=\"%s\"\r\n", uo->getFileNameAttach(i));
        //NON CODED MESSAGE/RFC822
        bool IsMessageRFC822;
        IsMessageRFC822 = false;
        if (strstr (CT, "MESSAGE/RFC822") != NULL) IsMessageRFC822 = true;
        if (IsMessageRFC822 == false) fprintf (FW, "Content-Transfer-Encoding: BASE64\r\n");
        fprintf (FW, "\r\n");
        int szfn = FileSize (truefn);
        if (IsMessageRFC822 == false)
          { 
          FR = fopen (truefn, "r");
          EncodeBase64File (FR, FW, szfn);
          fclose (FR);
          }
        else
          {
          FR = fopen (truefn, "r");
          initStr (linea);
          while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
            {
            if (strcmp (linea, "") != 0) fprintf (FW, "%s", linea);      
            initStr (linea);
            }
          fclose (FR);
          }
        }
      ++i;
      }
    fprintf (FW, "\r\n%s\r\n", ENDBOUNDARY);
    }  
  fclose (FW);  
  
  //GUARDO PRIMERO EN LA CARPETA SENTMAIL
  if ((savemsginsentmail) && (cclient != NULL)) 
    {
    bool bo;
    STRING stmsg;
    int sz;
    TBuffer SentMailBox, abuf;
    
    //SentMailBox = uo->getMailboxPrefix();
    //SentMailBox += sentmail;
    //LOG ("SentMailBox=%s", (char *)SentMailBox.cstr());
    xstrncpy (SentMailBox, CMAXBUFFER, cclient->expandMailboxName (sentmail, abuf));
    //LOG ("SentMailBox=%s", SentMailBox);    
        
    sz = FileSize (fntmp);
    FR = fopen (fntmp, "r");
    INIT (&stmsg, file_string, (void *)FR, sz);
    bo = cclient->appendMsg (SentMailBox, &stmsg);
    if (!bo)
      {      
      bo = cclient->createMailbox (SentMailBox);
      if (bo) 
        {      
        *createdsentmailfolder = true;
        INIT (&stmsg, file_string, (void *)FR, sz);
        bool bx;
        bx = cclient->appendMsg(SentMailBox, &stmsg);
        if (bx == false)
          {
          xstrncpy (errormsg, CMAXBUFFER, "Can not save msg in sent mail");
          }
        }
      else
        {
        xstrncpy (errormsg, CMAXBUFFER, "Can not save msg in sent mail");
        }  
      }
    fclose (FR); 
    }

  //ENVIO YA EL FICHERO
  FR = fopen (fntmp, "r");
  initStr (linea);
  while (fgets (linea, MAXLENGTHLINE, FR) != NULL)
    {
    if (strcmp (linea, "") != 0) 
      {
      if (strcmp (linea, ".\n") == 0) {xstrncpy (linea, MAXLENGTHLINE, " .\n");}
      if (strcmp (linea, ".\015\012") == 0) {xstrncpy (linea, MAXLENGTHLINE, " .\n");}        
      if (nntpsocket->Puts (linea) == -1) {fclose (FR); DeleteFile (fntmp); return false;}    
      }
    initStr (linea);
    }
  fclose (FR);
  
  snprintf (buffer, CMAXBUFFER, "\r\n.\r\n");
  if (nntpsocket->Puts (buffer) == -1) {fclose (FR); DeleteFile (fntmp); return false;}
  
  /*LEO LA LINEA DE ACEPTACION DE DATOS*/
  if (!nntpsocket->Gets (buffer, sizeof(buffer) -1)) {fclose (FR); DeleteFile (fntmp); return false;}
  sscanf (buffer, "%d %2000s", &cod, basura);
  if (cod != 240) {xstrncpy (errormsg, CMAXBUFFER, buffer); fclose (FR); DeleteFile (fntmp); return false;}  
  
  /*ENVIO QUIT*/
  snprintf (buffer, CMAXBUFFER, "QUIT\n");
  if (nntpsocket->Puts (buffer) == -1) {fclose (FR); DeleteFile (fntmp); return false;}
  /*LEO LA LINEA DE QUIT*/
  if (!nntpsocket->Gets (buffer, sizeof(buffer) -1)) {fclose (FR); DeleteFile (fntmp); return false;}
  sscanf (buffer, "%d %2000s", &cod, basura);
  if (cod != 205) {xstrncpy (errormsg, CMAXBUFFER, buffer); fclose (FR); DeleteFile (fntmp); return false;}  
  
  DeleteFile (fntmp);
  //LOG ("--%s--", fntmp);
  
  delete nntpsocket;
  return true;
  }          
  


/****************************************

S: 220 One ESMTP Server 
C: ehlo pp
S: 250-xxx.xx.xx Hello xxxxx pleased to meet you
S: 250-ENHANCEDSTATUSCODES
S: 250-PIPELINING
S: 250-8BITMIME
S: 250-SIZE 50000000
S: 250-DSN
S: 250-ETRN
S: 250-AUTH PLAIN LOGIN
S: 250-STARTTLS
S: 250-DELIVERBY
S: 250 HELP
C: auth login
S: 334 VXNlcm5hbWU6     base64 "Username:"
C: bXluYW1l             base64 "myname"
S: 334 UGFzc3dvcmQ6     base64 "Password:"
C: GFzc3dvcmQ6          base64 "secret"
S: 235 Authentication successful

*/////////////////////////////////////////
      
