/*
DateTimeUtils.h
*/

#ifndef __DATETIME_UTILS_H
#define __DATETIME_UTILS_H

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <pwd.h>
#include <malloc.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>
#include <syslog.h>
#include <dirent.h>
#include <sys/times.h>                                             
#include <signal.h>

#define NUMBER_MONTHS      12
#define NUMBER_DAYSFORWEEK  7

int CurrentYear (void);
int CurrentMonth (void);
int CurrentDay (void);
int DayOfWeek (long julianDay);
bool IsLeapYear (int year);
int DaysOfMonth (int amonth, int ayear);
long GregorianToJulian (int day, int month, int year);
void JulianToGregorian (long julianDay, int& day, int& month, int& year);
const char *getLongMonth (int amonth);
const char *getShortMonth (int amonth);
const char *getLongDay (int aday);
const char *getShortDay2 (int aday);    
const char *getShortDay3 (int aday);        
                                                           
#endif
