// ------------------------------------------------------------------------- //
// $Id: particle.cpp,v 1.3 2003/12/23 22:11:55 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

// ------------------------------------------------------------------------- //

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if HAVE_GL_GL_H
# include <GL/gl.h>
#endif

#if HAVE_OPENGL_GL_H	// MAC OS X
# include <OpenGL/gl.h>	
#endif

#if HAVE_CMATH
# include <cmath>
#endif

#include "image.h"
#include "primitive.h"
#include "particle.h"

Particle::Particle() : _pos(0.0, 0.0, 0.0), _age(0.0),
	_velocity(0.0, 0.0, 0.0), _color(1.0f, 1.0f, 1.0f, 1.0f),
	_size(5.0), _size_original(_size), _dead(true)
{
	_mat.makeIdentity();
}

ParticleSystem::ParticleSystem() : _particles(100), _pos(400.0, 400.0, 0.0), 
	_velocity(30.0, -10.0, 0.0), _gravity(0.0, 0.0, 0.0),
	_max_particles(100), _spawn_frequency(10.0), _particles_to_spawn(0.0)
{
	ImageLoader il;
	Image *img = il.load("../data/particle.png");
	assert(img);
	_tex = new Texture(img->get_width(),img->get_height());
	_tex->load_from_subimage(*img, 0, 0, img->get_width(), img->get_height());

}

ParticleSystem::~ParticleSystem()
{
	delete _tex;
}

int ParticleSystem::spawn_particles(int num)
{
	int spawned = 0;
	_particles_::iterator i = _particles.begin();
	while(num && i != _particles.end()) {
		if (!i->_dead) {
			i++;
			continue;
		}
		i->_dead = false;
		i->_pos = _pos;
		i->_velocity = v3(0.0,0.0f,0.0);
		//i->_velocity = v3(frand()*100.0 - 50.0, 100.0, 0.0);
		i->_size = i->_size_original = 6.0; //frand()*5.0 + 2.0;
		i->_age = 0.0f;
		i++;
		num--;
		spawned++;
	}
	return spawned;
}

void ParticleSystem::update(float delta_time)
{
	_pos += _velocity * delta_time;
	_particles_to_spawn += delta_time * _spawn_frequency;
	if (_particles_to_spawn >= 1.0f) {
		int num = (int)_particles_to_spawn;
		_particles_to_spawn -= spawn_particles(num);
	}
	float sizefactor = pow(0.3f, delta_time);
	for (_particles_::iterator p = _particles.begin();
			p != _particles.end(); ++p)
	{
		// Update position
		p->_pos += p->_velocity * delta_time;
		p->_velocity += _gravity * delta_time;
		//p->_velocity += (p->_velocity * (-0.5f*p->_velocity.length())) * delta_time;
		p->_age += delta_time;
		//p->_size = p->_size_original * (1.0 + p->_age*0.5);
		p->_color.a() = max(0, (int)(255 - p->_age*40.0));
		if (p->_color.a() == 0) {
			p->_dead = true;
		}
	}
}

void ParticleSystem::draw_particle(v3 &pos, float size, 
		byte r, byte g, byte b, byte a)
{
	glColor4ub(r, g, b, a);
	glTexCoord2f(0.0, 0.0);
	glVertex3f(pos.x() - size, pos.y() - size, 0.0f);
	glTexCoord2f(1.0, 0.0);
	glVertex3f(pos.x() + size, pos.y() - size, 0.0f);
	glTexCoord2f(1.0, 1.0);
	glVertex3f(pos.x() + size, pos.y() + size, 0.0f);
	glTexCoord2f(0.0, 1.0);
	glVertex3f(pos.x() - size, pos.y() + size, 0.0f);
}

void ParticleSystem::draw()
{
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, _tex->get_handle());
	glBegin(GL_QUADS);
	for (_particles_::iterator p = _particles.begin();
			p != _particles.end(); ++p)
	{
		draw_particle(p->_pos, p->_size, p->_color.r(), 
				p->_color.g(), p->_color.b(), p->_color.a());
	}
	draw_particle(_pos, 14.0, 255, 255, 255, 255);
	draw_particle(_pos, 28.0, 20, 20, 255, 128);
	glEnd();
	glDisable(GL_TEXTURE_2D);
}

// ------------------------------------------------------------------------ //

