package pifia;

use strict;
use MLDBM qw(SDBM_File);
use Fcntl;
use File::Basename;
require Exporter;
use vars qw(@ISA @EXPORT @EXPORT_OK);
@ISA = qw (Exporter);

use vars qw($picaobj);

@EXPORT = qw (perseval preserve tstamp readObjectFiles needNotify);
@EXPORT_OK = qw (perseval preserve tstamp readObjectFiles needNotify);

# ------------------------------------------ [ Internal Variables] -----------

$picaobj = "<#$picaobj#>";

# ------------------------------------------ [ Persistent environment ] ------

sub perseval (&@) {
   my $code = shift ;
   my %persist;
   my $name = basename $0;

   tie (%persist, 'MLDBM', "$picaobj/$name", O_CREAT|O_RDWR, 0666) or die $!;

   no strict;

   # Load variables
   foreach my $var (@_) {
      $var =~ /^(.)(.*)/;
      my ($char, $name) = ($1, $2);
      *{"$name"} = *{"main::$name"};
      $char = "" if $char eq '$';

      if ($char eq '') {
         eval "$var = \$persist{'$var'};";
      } else {
         eval "$var = $char"."{\$persist{'$var'}} if defined $char"."{\$persist{'$var'}};";
      }
   }
   # Execute code
   &$code;
   # Save variables
   foreach my $var (@_) {
      my $escape = ($var =~ /^[@%]/)?'\\':'';
      eval "\$persist{'$var'} = $escape$var;";
   }

   untie %persist;
}

# Fake sub for "simulating" new language syntax
sub preserve (@) { @_; }

# ----------------------------------------------------------------------------

# FUNCTION: tstamp(type)
# DESCRIPTION: creates a timestamp in the formar: YYYYMMDD. If we pass the
# parameter "time", it will create YYYYMMDD-HHMMSS
sub tstamp {
    my $type=shift;
    my @tmp=localtime();
    
    if ($type && ($type eq "time")) {
       sprintf("%04d%02d%02d-%02d:%02d:%02d",$tmp[5]+1900,$tmp[4]+1,$tmp[3],
                                             $tmp[2],$tmp[1],$tmp[0]);
    }
    else {
       sprintf("%04d%02d%02d",$tmp[5]+1900,$tmp[4]+1,$tmp[3]);
    }
}

# FUNCTION: readObjectFiles(fileName)
# DESCRIPTION: reads all the object files asociated with an alarm
sub readObjectFiles {
   my $name = shift;
   my @objfile;
   my @filenames;
   
   push(@filenames,"$picaobj/$name".".obj");
   while (<$picaobj/$name/*>) {
      push(@filenames,$_);
   }   
   foreach my $filename (@filenames) {
      open (FILE,"<$filename") or die("Can't open object file ($filename): $! \n");
      while (<FILE>) {
         next if (/^#|^\s+$|^$/);
         chomp $_;
         push @objfile, $_;
      }
      close FILE;
   }
   
   return @objfile;
}

# FUNCTION: needNotify(\%lastnotify)
# DESCRIPTION: returns true if we should notify an event: checks if a 
# "remind" period has passed since the last notification...
sub needNotify {
   my $name = shift;
   my $remind = shift;
   (!exists $main::lastnotify{$name} || 
    (time() > $main::lastnotify{$name} + $remind));
}

1;
