--TEST--
maxdb_get_metadata
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
	maxdb_query($link, "DROP TABLE IF EXISTS test_affected");
        maxdb_report (MAXDB_REPORT_ERROR);

	maxdb_query($link, "CREATE TABLE test_affected (foo int, bar varchar(10) ascii)");

	maxdb_query($link, "INSERT INTO test_affected VALUES (1, 'Zak')");
	maxdb_query($link, "INSERT INTO test_affected VALUES (2, 'Greant')");

	$stmt = maxdb_prepare($link, "SELECT * FROM test_affected");
	maxdb_execute($stmt);
	$result = maxdb_get_metadata($stmt);

	$fields = maxdb_fetch_fields($result);
	maxdb_free_result($result);

	var_dump($fields);

	maxdb_stmt_close($stmt);	
	maxdb_close($link);
?>
--EXPECTF--
array(2) {
  [0]=>
%s
    ["name"]=>
    string(3) "FOO"
    ["orgname"]=>
    string(0) ""
    ["table"]=>
    string(0) ""
    ["orgtable"]=>
    string(0) ""
    ["def"]=>
    string(0) ""
    ["max_length"]=>
    int(10)
    ["flags"]=>
    int(-1)
    ["type"]=>
    int(30)
    ["decimals"]=>
    int(10)
  }
  [1]=>
%s
    ["name"]=>
    string(3) "BAR"
    ["orgname"]=>
    string(0) ""
    ["table"]=>
    string(0) ""
    ["orgtable"]=>
    string(0) ""
    ["def"]=>
    string(0) ""
    ["max_length"]=>
    int(10)
    ["flags"]=>
    int(-1)
    ["type"]=>
    int(31)
    ["decimals"]=>
    int(10)
  }
}

