/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : msgdlg.c 
 * date    : 2001-11-20
 * modify  : 2001-12-13 by elcomski
 *
 */
/* ----------------------------------------------- */
#include <stdio.h>
#include <unistd.h>
#include <gtk/gtk.h>



/*----------------------------------------- */
/* Function definitions */
/*----------------------------------------- */
/*
 * Func : md_close_dialog
 * Context :
 * 
 */
void md_close_dialog (GtkWidget *widget, gpointer data)
{
	gtk_grab_remove (GTK_WIDGET (widget));    
}


/*
 * Func : md_signal_close
 * Context :
 * 
 */
void md_signal_close(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy (GTK_WIDGET (data));    
}


/*
 * Func : md_draw_condialog
 * Context :
 * 
 */
void md_draw_condialog(char *strmsg)
{
	GtkWidget *dialog_window;
	GtkWidget *label;
	GtkWidget *button;

	/* Create a new window */
	dialog_window = gtk_dialog_new ();

	gtk_signal_connect(GTK_OBJECT(dialog_window), "destroy", GTK_SIGNAL_FUNC(md_close_dialog), &dialog_window);
	gtk_window_set_title(GTK_WINDOW(dialog_window), "message box");
	gtk_container_border_width(GTK_CONTAINER(dialog_window),5);

	label = gtk_label_new(strmsg);
	gtk_misc_set_padding(GTK_MISC(label), 40, 20);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);

	button = gtk_button_new_with_label ("close");
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (md_signal_close), dialog_window);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_grab_default (button);
	gtk_widget_show (button);

	gtk_widget_show (dialog_window);

	gtk_grab_add (dialog_window);
    
}


/*
 * Func : msg_dialog
 * Context :
 * 
 */
void msg_dialog(char *strmsg)
{
	md_draw_condialog(strmsg);   
}
