/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <errno.h>

/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#ifndef _WIN32
#include <unistd.h>
#endif

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif


/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 93
#define YY_END_OF_BUFFER 94
static yyconst short int yy_accept[272] =
    {   0,
        0,    0,   94,   92,    1,   91,   92,   92,   72,   83,
       92,   92,   92,   85,   85,   85,   85,    7,   92,    9,
       83,   83,   83,   83,   83,   83,   83,   83,   92,   25,
       34,   66,   83,   20,   71,   83,   83,   31,   17,   83,
       83,   29,   69,   83,   54,   92,    1,   12,    0,    2,
        0,   72,   83,   13,    0,    3,    4,    0,   85,   85,
       85,    0,   90,   88,   87,   89,    0,    5,    8,   11,
       10,    6,   74,   83,   83,   75,   83,   73,   81,   81,
       83,   83,   15,   83,   83,   83,   83,   83,   83,   64,
       83,   83,   83,   83,   83,   83,   42,   48,   44,   52,

       83,   50,   46,   27,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   56,   62,   58,   60,   14,
        2,   84,   86,   77,   82,   82,   78,   83,   76,   83,
       36,   83,   83,   83,   83,   39,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       40,   83,   83,    0,   79,   80,   83,   33,   83,   83,
       65,   83,   18,   83,   21,   70,   83,   83,   30,   83,
       35,   19,   83,   28,   83,   83,   83,    0,   84,   24,
       83,   83,   83,   83,   83,   83,   83,   16,   83,   68,
       83,   53,   83,   83,   67,   83,   22,   83,   83,   23,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   32,   83,   38,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   26,   83,   55,   83,   57,   59,   83,   83,
       83,   83,   83,   83,   83,   83,   61,   63,   41,   83,
       43,   83,   83,   45,   37,   47,   83,   83,   51,   49,
        0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    1,    8,    9,    1,
        1,   10,   11,    1,   11,   12,    1,   13,   14,   15,
       16,   17,   17,   17,   17,   18,   18,    1,    1,   19,
       20,   21,    1,    7,   22,   22,   23,   22,   24,   25,
       26,   26,   26,   26,   26,   27,   28,   26,   26,   29,
       26,   30,   31,   32,   26,   26,   26,   33,   26,   26,
        1,   34,    1,   35,   36,    1,   37,   38,   39,   40,

       41,   42,   43,   44,   45,   26,   46,   47,   48,   49,
       50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
       60,   26,    1,   61,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[62] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    3,    3,    3,    3,    3,    3,    1,    1,
        1,    3,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    1,    1,    4,    3,    3,    3,    3,
        3,    3,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        1
    } ;

static yyconst short int yy_base[277] =
    {   0,
        0,    0,  411,  412,  408,  412,  389,   57,    0,    0,
      400,  398,  396,   80,  346,   50,   56,   46,  384,   47,
       46,   47,   54,   54,   51,   97,   93,   92,  368,   22,
       95,   91,  114,  105,  361,  115,  127,  360,  115,  344,
      161,  140,  350,  116,  145,  337,  395,  412,  132,  412,
      157,    0,    0,  412,  387,  412,  412,  183,  336,    0,
        0,  192,    0,    0,  412,  412,    0,  412,  412,  412,
      412,  412,    0,  114,  198,    0,  164,    0,  205,    0,
      194,  195,  412,  353,  352,  343,  344,  336,  341,    0,
      337,  351,  349,  335,  331,  336,    0,    0,    0,    0,

      328,    0,    0,    0,  327,  321,  334,  333,  334,  321,
      334,  337,  322,  319,  316,    0,    0,    0,    0,  412,
      221,  220,    0,    0,  236,    0,    0,   66,    0,  333,
        0,  314,  327,  330,  315,    0,  310,  317,  326,  308,
      310,  309,  304,  303,  308,  301,  301,  301,  302,  298,
        0,  296,  311,  249,    0,    0,  303,  303,  292,  292,
        0,  295,    0,  289,    0,    0,  302,  306,    0,  286,
        0,    0,  299,    0,  291,  302,  293,  255,  261,    0,
      287,  294,  286,  297,  278,  292,  292,    0,  286,    0,
      273,  291,  270,  289,    0,  273,    0,  268,  269,    0,

      271,  201,  279,  261,  281,  281,  275,  279,  246,  241,
      261,  247,    0,  258,    0,  242,  257,  242,  237,  241,
      242,  235,  232,  225,  226,  246,  240,  203,  207,  210,
      202,  202,  189,  198,  191,  191,  174,  178,  180,  144,
      137,  135,    0,  127,    0,  146,    0,    0,  140,  119,
       90,  100,   91,   95,   94,   74,    0,    0,    0,   86,
        0,   36,   38,    0,    0,    0,   26,   40,    0,    0,
      412,  300,  304,  306,  310,   78
    } ;

static yyconst short int yy_def[277] =
    {   0,
      271,    1,  271,  271,  271,  271,  271,  272,  273,  274,
      271,  275,  271,  271,   14,   14,   16,  271,  271,  271,
      274,  274,  274,  274,  274,  274,  274,  274,  271,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  271,  271,  271,  272,  271,
      272,  273,  274,  271,  275,  271,  271,  271,   14,   16,
       17,   17,   62,   62,  271,  271,  276,  271,  271,  271,
      271,  271,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  271,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,

      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  271,
      272,  271,  276,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  271,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  271,  271,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,

      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
        0,  271,  271,  271,  271,  271
    } ;

static yyconst short int yy_nxt[474] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
        4,    4,   14,   15,   16,   16,   16,   17,   18,   19,
       20,   10,   21,   10,   22,   10,   23,   24,   25,   26,
       27,   10,   28,    4,   29,   10,   10,   30,   31,   32,
       33,   34,   10,   35,   36,   10,   37,   24,   38,   10,
       39,   40,   41,   42,   10,   43,   44,   45,   28,   10,
       46,   50,   60,   60,   68,   69,   71,   72,   61,   61,
       61,   61,   61,   78,   84,   73,   75,   74,  155,  156,
      123,   85,  270,   76,   77,  269,  268,   62,  267,   78,
       51,   58,   59,   59,   60,   60,   60,   61,   73,   75,

       74,   62,   62,   62,   62,  271,   76,   77,  271,   79,
       79,   79,   79,   80,   80,   82,   62,   63,   62,   64,
       62,   62,   81,   65,   73,  266,   74,  265,   91,   66,
      113,   87,   82,  264,   75,   88,   50,   78,   67,  263,
      262,  261,  260,  124,   86,   81,   89,   73,   90,   74,
       92,   94,   97,   78,   98,   95,   76,   75,   99,  259,
      114,  121,  100,  101,  104,   51,  124,  107,  102,   81,
       93,  105,  103,   79,   79,   79,   79,   80,   80,   76,
      110,  115,  116,  258,  117,  257,  256,  255,  118,  254,
       51,  253,   81,  127,  111,  122,  122,  122,  122,  122,

      122,  109,  119,  271,   62,   62,   62,   62,   62,   62,
      125,  125,  125,  125,  126,  126,  127,   80,   80,   80,
       80,   80,   80,  128,  129,   50,  252,  251,  250,  249,
      248,   62,  122,  122,  122,  122,  122,  122,  209,  247,
      210,  246,  245,  154,  211,  244,  128,  129,  126,  126,
      126,  126,  126,  126,   51,  243,  242,  241,  212,  178,
      154,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  224,
      240,  225,  239,  238,  237,  226,  236,  235,  234,  227,
      233,  232,  231,  230,  223,  228,  222,  221,  220,  229,

       49,   49,   49,   49,   52,  219,   52,   52,   53,   53,
       55,   55,   55,   55,  218,  217,  216,  215,  214,  213,
      208,  207,  206,  205,  204,  203,  202,  201,  200,  199,
      198,  197,  196,  195,  194,  193,  192,  191,  190,  189,
      188,  187,  186,  185,  184,  183,  182,  181,  180,  177,
      176,  175,  174,  173,  172,  171,  170,  169,  168,  167,
      166,  165,  164,  163,  162,  161,  160,  159,  158,  157,
      153,  152,  151,  150,  149,  148,  147,  146,  145,  144,
      143,  142,  141,  140,  139,  138,  137,  136,  135,  134,
      133,  132,  131,  130,  271,   56,   47,  120,  112,  108,

      106,   96,   83,   70,  271,   57,   56,   54,   48,   47,
      271,    3,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271
    } ;

static yyconst short int yy_chk[474] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    8,   16,   16,   18,   18,   20,   20,   17,   17,
       17,   17,   17,   25,   30,   21,   22,   21,  128,  128,
      276,   30,  268,   23,   24,  267,  263,   16,  262,   25,
        8,   14,   14,   14,   14,   14,   14,   14,   21,   22,

       21,   14,   14,   14,   14,   17,   23,   24,   16,   26,
       26,   26,   26,   26,   26,   28,   14,   14,   14,   14,
       14,   14,   27,   14,   31,  260,   31,  256,   33,   14,
       44,   32,   28,  255,   34,   32,   49,   39,   14,  254,
      253,  252,  251,   74,   31,   27,   32,   31,   32,   31,
       33,   34,   36,   39,   36,   34,   37,   34,   36,  250,
       44,   51,   36,   36,   37,   49,   74,   39,   36,   42,
       33,   37,   36,   41,   41,   41,   41,   41,   41,   37,
       42,   45,   45,  249,   45,  246,  244,  242,   45,  241,
       51,  240,   42,   77,   42,   58,   58,   58,   58,   58,

       58,   41,   45,   62,   62,   62,   62,   62,   62,   62,
       75,   75,   75,   75,   75,   75,   77,   79,   79,   79,
       79,   79,   79,   81,   82,  121,  239,  238,  237,  236,
      235,   62,  122,  122,  122,  122,  122,  122,  202,  234,
      202,  233,  232,  122,  202,  231,   81,   82,  125,  125,
      125,  125,  125,  125,  121,  230,  229,  228,  202,  154,
      122,  154,  154,  154,  154,  154,  154,  178,  178,  178,
      178,  178,  178,  179,  179,  179,  179,  179,  179,  216,
      227,  216,  226,  225,  224,  216,  223,  222,  221,  216,
      220,  219,  218,  217,  214,  216,  212,  211,  210,  216,

      272,  272,  272,  272,  273,  209,  273,  273,  274,  274,
      275,  275,  275,  275,  208,  207,  206,  205,  204,  203,
      201,  199,  198,  196,  194,  193,  192,  191,  189,  187,
      186,  185,  184,  183,  182,  181,  177,  176,  175,  173,
      170,  168,  167,  164,  162,  160,  159,  158,  157,  153,
      152,  150,  149,  148,  147,  146,  145,  144,  143,  142,
      141,  140,  139,  138,  137,  135,  134,  133,  132,  130,
      115,  114,  113,  112,  111,  110,  109,  108,  107,  106,
      105,  101,   96,   95,   94,   93,   92,   91,   89,   88,
       87,   86,   85,   84,   59,   55,   47,   46,   43,   40,

       38,   35,   29,   19,   15,   13,   12,   11,    7,    5,
        3,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  271
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"
#define INITIAL 0
#line 2 "lex.l"
#define USE_PURE_PARSER

#ifdef USE_PURE_PARSER
#define YY_DECL int yylex (YYSTYPE *lvalp)
#define YY_LVALP lvalp
#else
#define YY_LVALP (&yylval)
#endif

/* get current pos (offset from start of line) */
#define YY_USER_ACTION lex_pos=yy_bp - YY_CURRENT_BUFFER->yy_ch_buf;

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "debug/debugtype.h"
#include "debugparse.h"
#include "parsehelper.h"

static int lex_pos;

static int char2int(char a, int base)
{
	int i;
	if ((a>='A') && (a<='Z')) {
		i=a-'A'+10;
	} else if ((a>='a') && (a<='z')) {
		i=a-'a'+10;
	} else if ((a>='0') && (a<='9')) {
		i=a-'0';
	} else return -1;
	if (i>=base) return -1;
	return i;
}

static int parse_integer(struct eval_scalar *i, char *num, int base, int lenmod)
{
	uint64 k = 0;
	int l = strlen(num)+lenmod;
	while (l--) {
		int c = char2int(*num, base);
		if (c==-1) return 0;
		k *= base;
		k += c;
		num++;
	}
	i->type = SCALAR_INT;
	i->scalar.integer.value = k;
	i->scalar.integer.type = TYPE_UNKNOWN;
	return 1;
}

static int parse_gpr(struct eval_scalar *i, char *s)
{
	int r = 0;
	if (tolower(*s) != 'r') return 0;
	s++;
	do {
		int c = char2int(*s, 10);
		if (c == -1) return 0;
		r *= 10;
		r += c;
		s++;
	} while (*s);
	if (r>31) return 0;
	i->type = SCALAR_REG;
	i->scalar.reg.type = REG_GPR;
	i->scalar.reg.num = r;
	return 1;
}

static int parse_fpr(struct eval_scalar *i, char *s)
{
	int r = 0;
	if (tolower(*s) != 'f') return 0;
	s++;
	if (tolower(*s) != 'r') return 0;
	s++;
	do {
		int c = char2int(*s, 10);
		if (c == -1) return 0;
		r *= 10;
		r += c;
		s++;
	} while (*s);
	if (r>31) return 0;
	i->type = SCALAR_REG;
	i->scalar.reg.type = REG_FPR;
	i->scalar.reg.num = r;
	return 1;
}

static int parse_float(struct eval_scalar *f, char *fpn)
{
	char *end;
	double d;
	d=strtod(fpn, &end);
	if (*end==0) {
		f->type=SCALAR_FLOAT;
		f->scalar.floatnum.value=d;
		return 1;
	}
	return 0;		
}

static int parse_cstring(struct eval_scalar *r, char *s, int len)
{
	char *result;

	int alloclen=len;
	if (!len) alloclen=1;

	r->type=SCALAR_STR;
	r->scalar.str.value=(char*)malloc(alloclen);
	/* translate */
	result=r->scalar.str.value;
	
	while (s && *s && len) {
		if (*s == '\\') {
			s++;len--;if (!len) break;
			switch (*s) {
				case '0':
					*result++='\0';
					break;
				case 'a':
					*result++='\a';
					break;
				case 'b':
					*result++='\b';
					break;
				case 'e':
					*result++='\e';
					break;
				case 'f':
					*result++='\f';
					break;
				case 'n':
					*result++='\n';
					break;
				case 'r':
					*result++='\r';
					break;
				case 't':
					*result++='\t';
					break;
				case 'v':
					*result++='\v';
					break;
				case '\"':
					*result++='"';
					break;
				case '\\':
					*result++='\\';
					break;
				case 'x': {
					int p, q;
					s++;len--;if (!len) break;
					p=char2int(*s, 16);
					if (p==-1)  return 0;
					s++;len--;if (!len) break;
					q=char2int(*s, 16);
					if (q==-1) return 0;
					*result++=(char)p*16+q;
					break;
				}
				default:
					*result++='\\';
					if (len) *result++=*s;
					break;
			}
		} else {
			*result++ = *s;
		}
		s++;len--;
	}
	
	r->scalar.str.len=result-r->scalar.str.value;
	
	return 1;
}

static int parse_pstring(struct eval_scalar *s, char *cstr, int len)
{
	int alloclen = len;
	if (!len) alloclen = 1;
	
	s->type = SCALAR_STR;
	s->scalar.str.value = (char*)malloc(alloclen);
	memmove(s->scalar.str.value, cstr, len);
	s->scalar.str.len = len;
	return 1;
}

void *lex_current_buffer()
{
	return (void*)YY_CURRENT_BUFFER;
}

int lex_current_buffer_pos()
{
	return lex_pos;
}

void lex_switch_buffer(void *buffer)
{
	yy_switch_to_buffer(buffer);	
}

void lex_delete_buffer(void *buffer)
{
	yy_delete_buffer(buffer);	
}

void *lex_scan_string_buffer(const char *str)
{
	return yy_scan_string(str);
}

#line 785 "lex.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 226 "lex.l"

#line 949 "lex.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 272 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 412 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 227 "lex.l"
/* nop */
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 228 "lex.l"
if (parse_cstring(&YY_LVALP->scalar, yytext+1, strlen(yytext+1)-1)) return EVAL_STR;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 229 "lex.l"
if (parse_pstring(&YY_LVALP->scalar, yytext+1, strlen(yytext+1)-1)) return EVAL_STR;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 230 "lex.l"
return EVAL_POW;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 231 "lex.l"
return EVAL_SHL;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 232 "lex.l"
return EVAL_SHR;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 233 "lex.l"
return EVAL_LT;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 234 "lex.l"
return EVAL_LE;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 235 "lex.l"
return EVAL_GT;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 236 "lex.l"
return EVAL_GE;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 237 "lex.l"
return EVAL_EQ;
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 238 "lex.l"
return EVAL_NE;
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 239 "lex.l"
return EVAL_LAND;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 240 "lex.l"
return EVAL_LOR;
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 241 "lex.l"
return EVAL_LXOR;
	YY_BREAK
case 16:
#line 243 "lex.l"
case 17:
#line 244 "lex.l"
case 18:
YY_RULE_SETUP
#line 244 "lex.l"
return EVAL_PRINT;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 245 "lex.l"
return EVAL_REGS;
	YY_BREAK
case 20:
#line 247 "lex.l"
case 21:
#line 248 "lex.l"
case 22:
YY_RULE_SETUP
#line 248 "lex.l"
return EVAL_FLOATS;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 249 "lex.l"
return EVAL_SETREG;
	YY_BREAK
case 24:
#line 251 "lex.l"
case 25:
YY_RULE_SETUP
#line 251 "lex.l"
return EVAL_BREAK;
	YY_BREAK
case 26:
#line 253 "lex.l"
case 27:
YY_RULE_SETUP
#line 253 "lex.l"
return EVAL_LIST_BREAK;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 254 "lex.l"
return EVAL_STEP;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 255 "lex.l"
return EVAL_STEP;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 256 "lex.l"
return EVAL_NEXT;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 257 "lex.l"
return EVAL_NEXT;
	YY_BREAK
case 32:
#line 259 "lex.l"
case 33:
#line 260 "lex.l"
case 34:
YY_RULE_SETUP
#line 260 "lex.l"
return EVAL_CONTINUE;
	YY_BREAK
case 35:
#line 262 "lex.l"
case 36:
YY_RULE_SETUP
#line 262 "lex.l"
return EVAL_QUIT;
	YY_BREAK
case 37:
#line 264 "lex.l"
case 38:
#line 265 "lex.l"
case 39:
#line 266 "lex.l"
case 40:
YY_RULE_SETUP
#line 266 "lex.l"
return EVAL_E2P;
	YY_BREAK
case 41:
#line 268 "lex.l"
case 42:
YY_RULE_SETUP
#line 268 "lex.l"
return EVAL_INSPECT_BYTE;
	YY_BREAK
case 43:
#line 270 "lex.l"
case 44:
YY_RULE_SETUP
#line 270 "lex.l"
return EVAL_INSPECT_HALF;
	YY_BREAK
case 45:
#line 272 "lex.l"
case 46:
YY_RULE_SETUP
#line 272 "lex.l"
return EVAL_INSPECT_WORD;
	YY_BREAK
case 47:
#line 274 "lex.l"
case 48:
YY_RULE_SETUP
#line 274 "lex.l"
return EVAL_INSPECT_DWORD;
	YY_BREAK
case 49:
#line 276 "lex.l"
case 50:
YY_RULE_SETUP
#line 276 "lex.l"
return EVAL_INSPECT_STRING;
	YY_BREAK
case 51:
#line 278 "lex.l"
case 52:
YY_RULE_SETUP
#line 278 "lex.l"
return EVAL_INSPECT_MEM;
	YY_BREAK
case 53:
#line 280 "lex.l"
case 54:
YY_RULE_SETUP
#line 280 "lex.l"
return EVAL_WATCH;
	YY_BREAK
case 55:
#line 282 "lex.l"
case 56:
YY_RULE_SETUP
#line 282 "lex.l"
return EVAL_WATCH_BYTE;
	YY_BREAK
case 57:
#line 284 "lex.l"
case 58:
YY_RULE_SETUP
#line 284 "lex.l"
return EVAL_WATCH_HALF;
	YY_BREAK
case 59:
#line 286 "lex.l"
case 60:
YY_RULE_SETUP
#line 286 "lex.l"
return EVAL_WATCH_WORD;
	YY_BREAK
case 61:
#line 288 "lex.l"
case 62:
YY_RULE_SETUP
#line 288 "lex.l"
return EVAL_WATCH_DWORD;
	YY_BREAK
case 63:
#line 290 "lex.l"
case 64:
YY_RULE_SETUP
#line 290 "lex.l"
return EVAL_DELETE_WATCH;
	YY_BREAK
case 65:
#line 292 "lex.l"
case 66:
YY_RULE_SETUP
#line 292 "lex.l"
return EVAL_DUMP;
	YY_BREAK
case 67:
#line 294 "lex.l"
case 68:
#line 295 "lex.l"
case 69:
YY_RULE_SETUP
#line 295 "lex.l"
return EVAL_DISASM;
	YY_BREAK
case 70:
#line 297 "lex.l"
case 71:
YY_RULE_SETUP
#line 297 "lex.l"
return EVAL_HELP;
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 298 "lex.l"
/* comment */
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 299 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_PC; return EVAL_REG_PC; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 300 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_CR; return EVAL_REG_CR; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 301 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_LR; return EVAL_REG_LR; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 302 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_XER; return EVAL_REG_XER; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 303 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_CTR; return EVAL_REG_CTR; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 304 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_MSR; return EVAL_REG_MSR; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 305 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_SRR0; return EVAL_REG_SRR0; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 306 "lex.l"
{ YY_LVALP->scalar.type=SCALAR_REG; YY_LVALP->scalar.scalar.reg.type=REG_SRR1; return EVAL_REG_SRR1; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 307 "lex.l"
if (parse_gpr(&YY_LVALP->scalar, yytext)) return EVAL_GPR;
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 308 "lex.l"
if (parse_fpr(&YY_LVALP->scalar, yytext)) return EVAL_FPR;
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 309 "lex.l"
YY_LVALP->ident=strdup(yytext); return EVAL_IDENT;
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 310 "lex.l"
if (parse_float(&YY_LVALP->scalar, yytext)) return EVAL_FLOAT;
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 311 "lex.l"
if (parse_integer(&YY_LVALP->scalar, yytext, 10, 0)) return EVAL_INT;
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 312 "lex.l"
if (parse_integer(&YY_LVALP->scalar, yytext+2, 16, 0)) return EVAL_INT;
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 313 "lex.l"
if (parse_integer(&YY_LVALP->scalar, yytext, 16, -1)) return EVAL_INT;
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 314 "lex.l"
if (parse_integer(&YY_LVALP->scalar, yytext, 10, -1)) return EVAL_INT;
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 315 "lex.l"
if (parse_integer(&YY_LVALP->scalar, yytext, 8, -1)) return EVAL_INT;
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 316 "lex.l"
if (parse_integer(&YY_LVALP->scalar, yytext, 2, -1)) return EVAL_INT;
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 317 "lex.l"
return '\n';
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 318 "lex.l"
return *yytext;
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 320 "lex.l"
ECHO;
	YY_BREAK
#line 1413 "lex.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 272 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 272 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 271);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef _WIN32
#include <unistd.h>
#else
#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 320 "lex.l"


