//
// C++ Implementation: aptpackages
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <assert.h>

#include <qstring.h>

#include <apt-pkg/error.h>
#include <apt-pkg/pkgrecords.h>	// for packageNamesToShortDescr
#include <apt-pkg/indexfile.h>	//

#include "aptpackages.h"

namespace NApt
{

AptPackages::AptPackages(const CacheAccess& ca)
{
	_pMap = ca.pMap();
	_pGCache = ca.pCache();
}


AptPackages::~AptPackages()
{
}


#include <stdlib.h>

// LocalitySort - Sort a version list by package file locality		/*{{{*/
// ---------------------------------------------------------------------
/* */
int LocalityCompare(const void *a, const void *b)
{
   pkgCache::VerFile *A = *(pkgCache::VerFile **)a;
   pkgCache::VerFile *B = *(pkgCache::VerFile **)b;
   
   if (A == 0 && B == 0)
      return 0;
   if (A == 0)
      return 1;
   if (B == 0)
      return -1;
   
   if (A->File == B->File)
      return A->Offset - B->Offset;
   return A->File - B->File;
}

void LocalitySort(pkgCache::VerFile **begin,
		  unsigned long Count,size_t Size)
{   
   qsort(begin,Count,Size,LocalityCompare);
}

bool AptPackages::search(Tagcoll::OpSet<string>& result, const string& pattern, bool searchDescr)
{
	/// @todo this function must nearly match the overloaded one - copy it when the other one is finished
// the code of this function is mainly taken from apt-cache - the serach section. I do not really understand
// it so it might not do what it should all the time.
// WARNING: this code does not conform with my naming scheme as it was mostly copied from apt-cache, so do
// not be confused by this.
	cerr << "Warning AptPackages::search(Tagcoll::OpSet<string>& result, const string& pattern, bool searchDescr) "
	<< "not yet implemented."<<endl;
	return false;
}



bool AptPackages::search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const string& pattern, bool searchDescr)
{
// the code of this function is mainly taken from apt-cache - the search section. I do not really understand
// it so it might not do what it should all the time.
// WARNING: this code does not conform with package search naming scheme as it was mostly copied 
// from apt-cache, so do not be confused by this.
	assert(_pGCache);
	pkgCache &Cache = *_pGCache;
	
	pkgDepCache::Policy Plcy;
	
	// Create the text record parser
	pkgRecords Recs(Cache);
	if (_error->PendingError() == true)
	{
		return false;
	}
	
	ExVerFile *VFList = new ExVerFile[Cache.HeaderP->PackageCount+1];
   memset(VFList,0,sizeof(*VFList)*Cache.HeaderP->PackageCount+1);	// set all pointer to be 0
	
	// Map versions that we want to write out onto the VerList array.
	for (pkgCache::PkgIterator P = Cache.PkgBegin(); P.end() == false; P++)
	{
		if ( QString(P.Name()).contains(pattern.c_str(),false) )
		{
			VFList[P->ID].NameMatch = true;
		}
		// Doing names only, drop any that dont match..
		if ( !searchDescr == true && VFList[P->ID].NameMatch == false)
			continue;
		// Find the proper version to use. 
		pkgCache::VerIterator V = Plcy.GetCandidateVer(P);
		if (V.end() == false)
			VFList[P->ID].Vf = V.FileList();
	}
		
	// Include all the packages that _provide_ matching names too
	for (pkgCache::PkgIterator P = Cache.PkgBegin(); P.end() == false; P++)
	{
		if (VFList[P->ID].NameMatch == false)
				continue;
		for (pkgCache::PrvIterator Prv = P.ProvidesList() ; Prv.end() == false; Prv++)
		{
			pkgCache::VerIterator V = Plcy.GetCandidateVer(Prv.OwnerPkg());
			if (V.end() == false)
			{
				VFList[Prv.OwnerPkg()->ID].Vf = V.FileList();
				VFList[Prv.OwnerPkg()->ID].NameMatch = true;
			}
		}
	}
	// I do not really understand this -> I guess it sorty the packages according to their Vf member,
	// important is that members with Vf==0 are moved to the end of the array
   LocalitySort(&VFList->Vf, Cache.HeaderP->PackageCount, sizeof(*VFList));	// BM sort using quicksort

	// Iterate over all the version records and check them
	for (ExVerFile *J = VFList; J->Vf != 0; J++)
	{
		pkgRecords::Parser &P = Recs.Lookup(pkgCache::VerFileIterator(Cache,J->Vf));
		bool match = true;	
		if (J->NameMatch == false)
		{
			string LongDesc = P.LongDesc();
			if ( QString(LongDesc.c_str()).contains(pattern.c_str(),false) )
				match = true;
			else
				match = false;
		}
		if (match)	// if the package matched the apt search
		{
			result.insert( handleMaker.getHandle( P.Name() ) );
		}
	}
	
	delete [] VFList;
	return result.empty();
}


bool AptPackages::search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const vector<string>& patterns, bool searchDescr)
{
	assert(!patterns.empty());
	search(result, handleMaker, patterns[0],searchDescr);	// search for the first pattern
	for (uint i=1; i<patterns.size(); ++i)
	{
		Tagcoll::OpSet<int> tmpResult;
		search(tmpResult, handleMaker, patterns[i], searchDescr);
		result ^= tmpResult;	// the new result is the intersection of the old ones
	}
	return result.empty();
}


// bool AptPackages::pkgNamesToShortDesc(map<int, string>& result, Tagcoll::HandleMaker<string>& handleMaker)
// {
// 	assert(_pGCache);
// 	pkgCache &Cache = *_pGCache;
// 	
// 	pkgDepCache::Policy Plcy;
// 	
// 	// Create the text record parser
// 	pkgRecords Recs(Cache);
// 	if ( _GetErrorObj()->PendingError() == true )	// this is the global error object from APT
// 	{
// 		string err;
// 		_GetErrorObj()->PopMessage(err);
// 		throw AptException(err);
// 		return false;
// 	}
// 	
// 	// Map versions that we want to write out onto the VerList array.
// 	for (pkgCache::PkgIterator P = Cache.PkgBegin(); P.end() == false; P++)
// 	{
// //		string shortDescr;
// 		// Find the proper version to use. 
// 		pkgCache::VerIterator V = Plcy.GetCandidateVer(P);
// 		if ( !V.end())	// if we could find a valid version
// 		{
// 			pkgRecords::Parser &P = Recs.Lookup( V.FileList() );	// V.FileList() gets us a VerFileIterator
// 			result[ handleMaker.getHandle(P.Name()) ] = P.ShortDesc();
// 		}
// 	}
// 	return true;
// }

}	// namespace NApt
