
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    log_brief.h
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a log file that can be
**           transported in a message.
**
******************************************************************************/

#ifndef LOG_BRIEF_H
#define LOG_BRIEF_H

#define MAX_LOG_BRIEF_NAME_LENGTH 15

/* this is a condensed host structure used for communication  */
/* between the management daemon and a managment application. */

typedef struct OSI_LOG_BRIEF
{
    osi_uint64 timestamp;
    char name[MAX_LOG_BRIEF_NAME_LENGTH];

} OSI_LOG_BRIEF;


void wrap_log_brief( OSI_LOG_BRIEF *log );
void unwrap_log_brief( OSI_LOG_BRIEF *log );


#endif
