/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.javagroups.tests.DiscoveryRequest;
import org.javagroups.tests.DiscoveryResponse;
import org.javagroups.tests.Result;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class McastDiscovery1_4 {
    int ttl;
    List handlers;
    InetAddress mcast_addr;
    int mcast_port;
    long interval;
    McastSender mcast_sender;
    boolean running;
    HashMap map;

    public void start() throws Exception {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            Enumeration<InetAddress> en2 = intf.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress bind_addr = en2.nextElement();
                this.map.put(bind_addr, new ArrayList());
                System.out.println("-- creating receiver for " + bind_addr);
                MessageHandler handler = new MessageHandler(bind_addr);
                this.handlers.add(handler);
                handler.start();
            }
        }
        this.mcast_sender = new McastSender();
        this.mcast_sender.start();
        System.out.println("press key to stop");
        System.out.flush();
        System.in.read();
        this.printValidInterfaces();
    }

    void printValidInterfaces() {
        InetSocketAddress tmp_addr;
        Iterator<Object> it2;
        List l;
        Map.Entry entry;
        ArrayList<InetSocketAddress> all_mbrs = new ArrayList<InetSocketAddress>();
        HashMap map_copy = (HashMap)this.map.clone();
        System.out.println("\n========================================================");
        System.out.println("Responses received ordered by interface:\n");
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            InetAddress bind_interface = (InetAddress)entry.getKey();
            System.out.println(bind_interface.getHostAddress() + ":\t " + entry.getValue());
        }
        it = this.map.values().iterator();
        while (it.hasNext()) {
            l = (List)((Object)it.next());
            it2 = l.iterator();
            while (it2.hasNext()) {
                tmp_addr = (InetSocketAddress)it2.next();
                if (all_mbrs.contains(tmp_addr)) continue;
                all_mbrs.add(tmp_addr);
            }
        }
        it = all_mbrs.iterator();
        while (it.hasNext()) {
            tmp_addr = (InetSocketAddress)((Object)it.next());
            it2 = this.map.entrySet().iterator();
            while (it2.hasNext()) {
                entry = (Map.Entry)it2.next();
                l = (List)entry.getValue();
                if (l.contains(tmp_addr)) continue;
                it2.remove();
            }
        }
        if (this.map.size() > 0) {
            System.out.println("\n-- Valid interfaces are " + this.map.keySet() + '\n');
        } else {
            System.out.println("\nNo valid interfaces found, listing interfaces by number of responses/interface:\n(it is best to use the interface with the most responses)");
            TreeSet<Result> s = new TreeSet<Result>();
            it = map_copy.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                Result r = new Result((InetAddress)entry.getKey(), ((List)entry.getValue()).size());
                s.add(r);
            }
            Stack st = new Stack();
            it = s.iterator();
            while (it.hasNext()) {
                st.push(it.next());
            }
            while (!st.empty()) {
                System.out.println("-- " + st.pop());
            }
        }
        System.out.println("\nUse of any of the above interfaces in \"UDP(bind_addr=<interface>)\" will guarantee that the members will find each other");
        System.out.println("========================================================\n\n");
    }

    public static void main(String[] args) {
        int ttl = 32;
        String mcast_addr = "228.8.8.8";
        int mcast_port = 5000;
        long interval = 2000L;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                McastDiscovery1_4.help();
                return;
            }
            if (args[i].equals("-mcast_addr")) {
                mcast_addr = args[++i];
            } else if (args[i].equals("-mcast_port")) {
                mcast_port = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-interval")) {
                interval = Long.parseLong(args[++i]);
            } else if (args[i].equals("-ttl")) {
                ttl = Integer.parseInt(args[++i]);
            } else {
                McastDiscovery1_4.help();
                return;
            }
            ++i;
        }
        try {
            new McastDiscovery1_4(InetAddress.getByName(mcast_addr), mcast_port, interval, ttl).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("McastDiscovery1_4 [-mcast_addr <multicast address>] [-mcast_port <port>] [-interval <time between mcasts (msecs)>] [-ttl <ttl>]");
    }

    private final /* synthetic */ void this() {
        this.ttl = 32;
        this.handlers = new ArrayList();
        this.mcast_addr = null;
        this.mcast_port = 5000;
        this.interval = 2000L;
        this.mcast_sender = null;
        this.running = true;
        this.map = new HashMap();
    }

    public McastDiscovery1_4(InetAddress mcast_addr, int mcast_port, long interval, int ttl) {
        this.this();
        this.mcast_addr = mcast_addr;
        this.mcast_port = mcast_port;
        this.interval = interval;
        this.ttl = ttl;
    }

    class McastSender
    extends Thread {
        public void run() {
            while (McastDiscovery1_4.this.running) {
                Iterator it = McastDiscovery1_4.this.handlers.iterator();
                while (it.hasNext()) {
                    MessageHandler handler = (MessageHandler)it.next();
                    handler.sendDiscoveryRequest(McastDiscovery1_4.this.ttl);
                }
                try {
                    McastSender.sleep(McastDiscovery1_4.this.interval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        McastSender() {
            this.setName("McastSender");
            this.setDaemon(true);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MessageHandler {
        MulticastSocket mcast_sock;
        DatagramSocket sock;
        McastReceiver mcast_receiver;
        UcastReceiver ucast_receiver;
        InetAddress local_addr;
        int local_port;

        void start() throws Exception {
            McastDiscovery1_4.this.running = true;
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            this.mcast_receiver = new McastReceiver();
            this.mcast_receiver.start();
        }

        void stop() {
            McastDiscovery1_4.this.running = false;
            if (this.mcast_sock != null) {
                this.mcast_sock.close();
                this.mcast_sock = null;
            }
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }

        void sendDiscoveryRequest(int ttl) {
            DiscoveryRequest req = new DiscoveryRequest(this.local_addr, this.local_port);
            System.out.println("--> " + req);
            try {
                byte[] buf = Util.objectToByteBuffer(req);
                DatagramPacket packet = new DatagramPacket(buf, buf.length, McastDiscovery1_4.this.mcast_addr, McastDiscovery1_4.this.mcast_port);
                this.mcast_sock.send(packet);
            }
            catch (Exception ex) {
                System.err.println("McastDiscovery1_4.sendDiscoveryRequest(): " + ex);
            }
        }

        private final /* synthetic */ void this() {
            this.mcast_sock = null;
            this.sock = null;
            this.mcast_receiver = null;
            this.ucast_receiver = null;
            this.local_addr = null;
            this.local_port = 0;
        }

        MessageHandler(InetAddress bind_interface) throws Exception {
            this.this();
            this.mcast_sock = new MulticastSocket(McastDiscovery1_4.this.mcast_port);
            this.mcast_sock.setInterface(bind_interface);
            this.mcast_sock.setTimeToLive(McastDiscovery1_4.this.ttl);
            this.mcast_sock.joinGroup(McastDiscovery1_4.this.mcast_addr);
            this.sock = new DatagramSocket(0, bind_interface);
            this.local_addr = this.sock.getLocalAddress();
            this.local_port = this.sock.getLocalPort();
        }

        class McastReceiver
        extends Thread {
            byte[] buf;
            DatagramPacket mcast_packet;
            DatagramPacket rsp_packet;
            DiscoveryRequest req;
            DiscoveryResponse rsp;

            public void run() {
                while (McastDiscovery1_4.this.running) {
                    this.buf = new byte[16000];
                    this.mcast_packet = new DatagramPacket(this.buf, this.buf.length);
                    try {
                        MessageHandler.this.mcast_sock.receive(this.mcast_packet);
                        this.req = (DiscoveryRequest)Util.objectFromByteBuffer(this.mcast_packet.getData());
                        System.out.println("<-- " + this.req);
                        this.rsp = new DiscoveryResponse(new InetSocketAddress(MessageHandler.this.local_addr, MessageHandler.this.local_port), this.req.sender_addr.getAddress());
                        this.buf = Util.objectToByteBuffer(this.rsp);
                        this.rsp_packet = new DatagramPacket(this.buf, this.buf.length, this.req.sender_addr);
                        MessageHandler.this.sock.send(this.rsp_packet);
                    }
                    catch (Exception ex) {
                        System.err.println("McastReceiver.run(): " + ex + ", rsp_packet=" + this.rsp_packet.getSocketAddress() + ", length=" + this.rsp_packet.getLength() + " bytes");
                        ex.printStackTrace();
                    }
                }
            }

            McastReceiver() {
                this.setName("McastReceiver");
                this.setDaemon(true);
            }
        }

        class UcastReceiver
        extends Thread {
            public void run() {
                while (McastDiscovery1_4.this.running) {
                    try {
                        InetSocketAddress responder_addr;
                        byte[] buf = new byte[16000];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        MessageHandler.this.sock.receive(packet);
                        DiscoveryResponse rsp = (DiscoveryResponse)Util.objectFromByteBuffer(packet.getData());
                        System.out.println("<== " + rsp);
                        InetAddress bind_interface = rsp.interface_used;
                        ArrayList<InetSocketAddress> l = (ArrayList<InetSocketAddress>)McastDiscovery1_4.this.map.get(bind_interface);
                        if (l == null) {
                            l = new ArrayList<InetSocketAddress>();
                            McastDiscovery1_4.this.map.put(bind_interface, l);
                        }
                        if (l.contains(responder_addr = rsp.discovery_responder)) continue;
                        l.add(responder_addr);
                    }
                    catch (Exception ex) {
                        System.err.println("UcastReceiver.run(): " + ex);
                    }
                }
            }

            UcastReceiver() {
                this.setName("UcastReceiver");
                this.setDaemon(true);
            }
        }
    }
}

