/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.blocks.ConnectionTable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConnectionTableUnitTest
extends TestCase {
    ConnectionTable ct1;
    ConnectionTable ct2;
    final int port1 = 5555;
    final int port2 = 6666;
    static /* synthetic */ Class class$org$javagroups$tests$ConnectionTableUnitTest;

    protected void setUp() throws Exception {
        this.ct1 = new ConnectionTable(5555);
        this.log("address of ct1: " + this.ct1.getLocalAddress());
        this.ct2 = new ConnectionTable(6666);
        this.log("address of ct2: " + this.ct2.getLocalAddress());
    }

    public void tearDown() throws Exception {
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
    }

    public void testSetup() {
        ConnectionTableUnitTest.assertNotSame((Object)this.ct1.getLocalAddress(), (Object)this.ct2.getLocalAddress());
    }

    public void testSendToSelf() throws Exception {
        long NUM = 1000L;
        Address myself = this.ct1.getLocalAddress();
        MyReceiver r = new MyReceiver(this.ct1, NUM, false);
        this.ct1.setReceiver(r);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(new Message(myself, null, null));
            ++i;
        }
        this.log("sent " + NUM + " msgs");
        r.waitForCompletion();
        long total_time = r.stop_time - r.start_time;
        this.log("number expected=" + r.getNumExpected() + ", number received=" + r.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r.getNumReceived() + " ms/msg)");
        ConnectionTableUnitTest.assertEquals((long)r.getNumExpected(), (long)r.getNumReceived());
    }

    public void testSendToOther() throws Exception {
        long NUM = 1000L;
        Address other = this.ct2.getLocalAddress();
        MyReceiver r = new MyReceiver(this.ct2, NUM, false);
        this.ct2.setReceiver(r);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(new Message(other, null, null));
            ++i;
        }
        this.log("sent " + NUM + " msgs");
        r.waitForCompletion();
        long total_time = r.stop_time - r.start_time;
        this.log("number expected=" + r.getNumExpected() + ", number received=" + r.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r.getNumReceived() + " ms/msg)");
        ConnectionTableUnitTest.assertEquals((long)r.getNumExpected(), (long)r.getNumReceived());
    }

    public void testSendToOtherGetResponse() throws Exception {
        long NUM = 1000L;
        Address other = this.ct2.getLocalAddress();
        MyReceiver r1 = new MyReceiver(this.ct1, NUM, false);
        MyReceiver r2 = new MyReceiver(this.ct2, NUM, true);
        this.ct1.setReceiver(r1);
        this.ct2.setReceiver(r2);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(new Message(other, null, null));
            ++i;
        }
        this.log("sent " + NUM + " msgs");
        r1.waitForCompletion();
        long total_time = r1.stop_time - r1.start_time;
        this.log("number expected=" + r1.getNumExpected() + ", number received=" + r1.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r1.getNumReceived() + " ms/msg)");
        ConnectionTableUnitTest.assertEquals((long)r1.getNumExpected(), (long)r1.getNumReceived());
    }

    void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class clazz = class$org$javagroups$tests$ConnectionTableUnitTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$ConnectionTableUnitTest = ConnectionTableUnitTest.class$("[Lorg.javagroups.tests.ConnectionTableUnitTest;", false);
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.port1 = 5555;
        this.port2 = 6666;
    }

    public ConnectionTableUnitTest(String name) {
        super(name);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MyReceiver
    implements ConnectionTable.Receiver {
        long num_expected;
        long num_received;
        long start_time;
        long stop_time;
        boolean done;
        boolean send_response;
        long modulo;
        ConnectionTable ct;

        public long getNumReceived() {
            return this.num_received;
        }

        public long getNumExpected() {
            return this.num_expected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void receive(Message msg) {
            Address sender = msg.getSrc();
            ++this.num_received;
            if (this.num_received % this.modulo == 0L) {
                ConnectionTableUnitTest.this.log("received msg# " + this.num_received);
            }
            if (this.send_response && this.ct != null) {
                this.ct.send(new Message(sender, null, null));
            }
            if (this.num_received < this.num_expected) return;
            MyReceiver myReceiver = this;
            synchronized (myReceiver) {
                if (this.done) return;
                this.done = true;
                this.stop_time = System.currentTimeMillis();
                this.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForCompletion() {
            MyReceiver myReceiver = this;
            synchronized (myReceiver) {
                while (!this.done) {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.num_expected = 0L;
            this.num_received = 0L;
            this.start_time = 0L;
            this.stop_time = 0L;
            this.done = false;
            this.send_response = false;
        }

        MyReceiver(ConnectionTable ct, long num_expected, boolean send_response) {
            this.this();
            this.ct = ct;
            this.num_expected = num_expected;
            this.send_response = send_response;
            this.start_time = System.currentTimeMillis();
            this.modulo = num_expected / 10L;
        }
    }
}

