/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class ChatTest {
    public static void main(String[] stringArray) {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        byte[] byArray = new byte[]{};
        int n = 32;
        Receiver receiver = null;
        int n2 = 5555;
        try {
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string = stringArray[n3];
                if (string.equals("-help")) {
                    ChatTest.help();
                    return;
                }
                if (string.equals("-bind_addr")) {
                    inetAddress2 = InetAddress.getByName(stringArray[++n3]);
                } else if (string.equals("-mcast_addr")) {
                    inetAddress = InetAddress.getByName(stringArray[++n3]);
                } else if (string.equals("-ttl")) {
                    n = Integer.parseInt(stringArray[++n3]);
                } else if (string.equals("-port")) {
                    n2 = Integer.parseInt(stringArray[++n3]);
                } else {
                    ChatTest.help();
                    return;
                }
                ++n3;
            }
            if (inetAddress == null) {
                inetAddress = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
        try {
            MulticastSocket multicastSocket = new MulticastSocket(n2);
            multicastSocket.setTimeToLive(n);
            if (inetAddress2 != null) {
                multicastSocket.setInterface(inetAddress2);
            }
            System.out.println("Socket=" + multicastSocket.getLocalAddress() + ":" + multicastSocket.getLocalPort() + ", ttl=" + multicastSocket.getTimeToLive() + ", bind interface=" + multicastSocket.getInterface() + ", loopback disabled=" + multicastSocket.getLoopbackMode() + ", network interface=" + multicastSocket.getNetworkInterface().getName());
            receiver = new Receiver(multicastSocket);
            receiver.start();
            DataInputStream dataInputStream = new DataInputStream(System.in);
            while (true) {
                System.out.print("> ");
                String string = dataInputStream.readLine();
                if (string.startsWith("quit") || string.startsWith("exit")) {
                    if (receiver == null) break;
                    receiver.stop();
                    break;
                }
                byArray = string.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n2);
                multicastSocket.send(datagramPacket);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    static void help() {
        System.out.println("ChatTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <multicast port that receivers are listening on>] [-ttl <time to live for mcast packets>]");
    }

    private static class Receiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t = null;

        Receiver(DatagramSocket datagramSocket) {
            this.sock = datagramSocket;
        }

        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received packet from " + this.packet.getAddress().getHostAddress() + ":" + this.packet.getPort() + ": " + new String(this.packet.getData()));
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "McastSenderTest.Receiver thread");
            this.t.start();
        }

        void stop() {
            block2: {
                if (this.t == null || !this.t.isAlive()) break block2;
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

