# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: orpg_update.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: orpg_update.py,v 1.6 2002/06/10 01:12:37 markt1964 Exp $
#
# Description: classes updateing openrpg code
#

import zipfile
import urllib
import os
import orpg.orpg_xml

##
##  This objects is designed to allow for diffrent package types.
##	A feature we DON"T current use.  But its here in case we do.
##

class orpg_update:
    def __init__(self,list_url,log_func=None):
        self.zip_file = None
        self.packages = None
        self.list_url = list_url
        self.log_func = log_func

    def log_msg(self,s):
        if self.log_func:
            self.log_func(s)
        else:
            print s
        
    def get_packages(self):
        #self.log_msg("Downloading Package list...")
        file = urllib.urlopen(self.list_url)
        data = file.read()
        xml_dom = orpg.orpg_xml.parseXml(data)
        xml_dom = xml_dom._get_documentElement()
        self.packages = xml_dom.getElementsByTagName('orpg_package')
        return self.packages

    def get_package(self,type="release"):
        if self.packages == None:
            self.get_packages()
        for p in self.packages:
            if type == p.getAttribute("type"):
                return p
        return None

    def is_up2date(self, version, type="release"):
        p = self.get_package(type)
        return (version == p.getAttribute("version"))
        
    def is_later(self, version, type="release"):
        p = self.get_package(type)
        return (int(version) < int(p.getAttribute("version")))
        
    def update(self,type="release"):
        p = self.get_package(type)
        self.log_msg("Updating to OpenRPG version " + p.getAttribute("version"))
        self.get_zip_url(p.getAttribute("url"))
        self._extract()
        self.log_msg("Done updating.")

    def get_zip_url(self, url):
        self.log_msg("Downloading openrpg package...")
        d = urllib.urlretrieve( url )
        self.zip_file = zipfile.ZipFile(d[0])

    def _extract(self):
        zipped_files = self.zip_file.namelist()
        # remove "openrpg/" dir name for the list
        #zipped_files.remove("openrpg/")
        # loop through files and create them
        for zipped_file in zipped_files:
            # remove the "openrpg/" dir in the zipped_file name
            #new_file = zipped_file.replace("openrpg/","",1)
            self._validate_dir(zipped_file)
            # make sure its a file and not a dir
            if zipped_file[len(zipped_file)-1] != "/":
                f = open(zipped_file,'wb')
                #self.log_msg("writing " + zipped_file)
                f.write(self.zip_file.read(zipped_file))
                f.close()       
    
    def _validate_dir(self,file_name):
        # get dirs in path namne
        #self.log_msg("validating " + file_name)
        dirs = file_name.split("/")
        # drop the file 
        dirs = dirs[:len(dirs)-1]
        total_path = ""
        for dir in dirs:
            total_path += dir + "/"
            #self.log_msg("checking " + total_path)
            if not os.access(total_path,os.F_OK):                
                #total_path += dir + "/"
                #self.log_msg("creating " + total_path)
                os.mkdir(total_path)
            #total_path += dir + "/"
        
    
if __name__ == '__main__':
    choice = raw_input("Update/Install OpenRPG? (y/n))")
    if choice == "y" or choice == "yes":
        updater = orpg_update("http://my.openrpg.com/orpg_packages.xml")
        updater.update()

        # for local testing
        #updater = orpg_update("")
        #updater.get_zip_url("/home/chris/openrpg-0.9.8a-src.zip")
        #updater._extract()
        
