#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: orpg/mapper/map_handler.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: map_handler.py,v 1.5 2003/11/21 11:47:14 digitalxero Exp $
#
# Description: map layer handler
#
__version__ = "$Id: map_handler.py,v 1.5 2003/11/21 11:47:14 digitalxero Exp $"

from base_handler import *

CTRL_MAP_WIDTH = wxNewId()
CTRL_MAP_HEIGHT = wxNewId()
CTRL_MAP_NAME = wxNewId()
CTRL_MAP_APPLY = wxNewId()
CTRL_MAP_LOAD_DEFAULT = wxNewId()

class map_handler(base_layer_handler):
    def __init__(self, parent, id, canvas):
        base_layer_handler.__init__(self, parent, id, canvas)

    def build_ctrls(self):
        base_layer_handler.build_ctrls(self)

        self.width = orpgTextCtrl(self, CTRL_MAP_WIDTH, size=(75,25))
        self.height = orpgTextCtrl(self, CTRL_MAP_HEIGHT, size=(75,25))
        #self.name = orpgTextCtrl(self, CTRL_MAP_NAME, size=(200,25))

        self.apply_button = wxButton(self, CTRL_MAP_APPLY, "Apply!", style=wxBU_EXACTFIT)
        self.load_default = wxButton(self, CTRL_MAP_LOAD_DEFAULT, "Default Map", style=wxBU_EXACTFIT)

        self.sizer.Prepend(20,25,1)
        self.sizer.Prepend(self.load_default, 0, wxEXPAND)
        self.sizer.Prepend(20,25)
        self.sizer.Prepend(self.apply_button, 0, wxEXPAND)
        self.sizer.Prepend(20,25)
        #self.sizer.Prepend(self.name, 0, wxEXPAND)
        #self.sizer.Prepend(wxStaticText(self, -1, "Name: "),0,wxALIGN_CENTER)
        #self.sizer.Prepend(10,25)
        self.sizer.Prepend(self.height, 0, wxEXPAND)
        self.sizer.Prepend(wxStaticText(self, -1, "Height: "),0,wxALIGN_CENTER)
        self.sizer.Prepend(10,25)
        self.sizer.Prepend(self.width, 0, wxEXPAND)
        self.sizer.Prepend(wxStaticText(self, -1, "Width: "),0,wxALIGN_CENTER)
        self.sizer.Prepend(10,25)

        EVT_BUTTON(self, CTRL_MAP_APPLY, self.on_apply)
        EVT_BUTTON(self, CTRL_MAP_LOAD_DEFAULT, self.on_load_default)
        self.update_info()

    def update_info(self):
        size = self.canvas.get_size()
        self.width.SetValue(str(size[0]))
        self.height.SetValue(str(size[1]))

    def build_menu(self,label = "Grid"):
        base_layer_handler.build_menu(self,label)

    def on_load_default(self, evt):
        self.map_frame.load_default()

    def on_apply(self, evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        try:
            size = (int(self.width.GetValue()),int(self.height.GetValue()))
        except:
            wxMessageBox("Invalide Map Size!","Map Properties")
            return
        self.canvas.set_size(size)
        self.update_info()
        self.canvas.send_map_data()
        self.canvas.Refresh()




