# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: background.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: background.py,v 1.12 2002/06/11 01:06:01 markt1964 Exp $
#
# Description: This file contains some of the basic definitions for the chat
# utilities in the orpg project.
#
__version__ = "$Id: background.py,v 1.12 2002/06/11 01:06:01 markt1964 Exp $"

from base import *

##-----------------------------
## background layer
##-----------------------------

BG_NONE = 0
BG_TEXTURE = 1
BG_IMAGE = 2
BG_COLOR = 3

class layer_back_ground(layer_base):
    def __init__(self, canvas):
        layer_base.__init__(self)
        self.canvas = canvas
        self.r_h = RGBHex()
        self._protected_attr = ["type","bg_color","img_path"]
        self.clear()
        self._clean_all_attr()

    def error_loading_image(self,image):
        msg = "Unable to load image:" + `image`
        dlg = wxMessageDialog(self.canvas,msg,'File not Found',wxICON_EXCLAMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def clear(self):
        self.type = BG_NONE
        self.bg_bmp = None
        self.bg_color = None
        self.img_path = None

    def get_type(self):
        return self.type
        
    def get_img_path(self):
        if self.img_path:
            return self.img_path
        else:
            return ""

    def get_color(self):
        hexcolor = "#FFFFFF"
        if self.bg_color:
            (red,green,blue) = self.bg_color.Get()
            hexcolor = self.r_h.hexstring(red, green, blue)
        return hexcolor

    def set_texture(self, path):
        self.type = BG_TEXTURE
        # Begin ted's changes for map bg persistency
        # self.bg_color = None
        # End ted's changes
        if self.img_path != path:
            try:
                self.bg_bmp = load_img(path,"texture",self.bg_bmp)
                if self.bg_bmp == None:
                    raise Exception, "Invalid image type!"
            except:
                self.error_loading_image(path)
        self.img_path = path
        #self.canvas.Refresh()

    def set_image(self, path,scale):
        self.type = BG_IMAGE
        #self.bg_color = None
        if self.img_path != path:
            self.bg_bmp = load_img(path,"background",self.bg_bmp)
            try:
                #self.bg_bmp = load_img(path,"background",self.bg_bmp)
                if self.bg_bmp == None:
                    raise Exception, "Invalid image type!"
            except:
                self.error_loading_image(path)
        self.img_path = path
        # Begin ted's changes for map bg persistency
        # self.canvas.SetBackgroundColour(wxWHITE)
        # End ted's changes
        #self.canvas.Refresh()
        return (self.bg_bmp.GetWidth(),self.bg_bmp.GetHeight())

    def set_color(self, color):
        self.type = BG_COLOR
        (r,g,b) = color.Get()
        self.bg_color = cmpColour(r,g,b)
        self.canvas.SetBackgroundColour(self.bg_color)
        # Begin ted's changes for map bg persistency
        # del self.bg_bmp
        # self.bg_bmp = None
        # self.img_path = None
        try:
          print 'color set, redrawing map'
          #self.canvas.on_paint( None )
        except Exception,e:
          print 'map redraw choked because of',e
        # End ted's changes
        #self.canvas.Refresh()


    def draw(self,dc,scale,topleft,size):
        if self.bg_bmp == None:
            return false
        if (self.type != BG_TEXTURE) and (self.type!= BG_IMAGE):
            return false
        dc2=wxMemoryDC()
        dc2.SelectObject(self.bg_bmp)
        tl=[int(topleft[0]/scale),int(topleft[1]/scale)]
        rt=[int((topleft[0]+size[0]+1)/scale)+1,int((topleft[1]+size[1]+1)/scale)+1]
        sz = self.canvas.size
        if (rt[0]>sz[0]):
            rt[0]=sz[0]
        if (rt[1]>sz[1]):
            rt[1]=sz[1]
        if self.type == BG_TEXTURE:
            w = self.bg_bmp.GetWidth()
            h = self.bg_bmp.GetHeight()
            x=int(tl[0]/w)*w
            if x<tl[0]:
                posx=tl[0]
                cl=tl[0]-x
            else:
                cl=0
                posx=x
            while x < rt[0]:
                if x+w>rt[0]:
                    cr=x+w-rt[0]
                else:
                    cr=0
                y=int(tl[1]/h)*h
                if y<tl[1]:
                    posy=tl[1]
                    ct=tl[1]-y
                else:
                    ct=0
                    posy=y
                while y < rt[1]:
                    if y+h>rt[1]:
                        cb=y+h-rt[1]
                    else:
                        cb=0
                    if (x>=tl[0] and x+w<rt[0] and y>=tl[1] and y+h<rt[1]):
                        dc.DrawBitmap(self.bg_bmp, x, y)
                    else:                        
                        dc.Blit(posx,posy,w-cr-cl,h-cb-ct,dc2,cl,ct)
                    ct = 0
                    y = y + h
                    posy = y
                cl=0
                x = x + w
                posx = x
        elif self.type == BG_IMAGE:
            w = self.bg_bmp.GetWidth()
            h = self.bg_bmp.GetHeight()
            x=0
            y=0
            if (x>=tl[0] and x+w<rt[0] and y>=tl[1] and y+h<rt[1]):
                dc.DrawBitmap(self.bg_bmp, x, y)
            else:
                if x<tl[0]:
                    posx=tl[0]
                    cl=tl[0]-x
                else:
                    cl=0
                    posx=x
                if y<tl[1]:
                    posy=tl[1]
                    ct=tl[1]-y
                else:
                    ct=0
                    posy=y
                if x+w>rt[0]:
                    cr=x+w-rt[0]
                else:
                    cr=0
                if y+h>rt[1]:
                    cb=y+h-rt[1]
                else:
                    cb=0
                dc.Blit(posx,posy,w-cr-cl,h-cb-ct,dc2,cl,ct)
        dc2.SelectObject(wxNullBitmap)
        del dc2
        return true

    def toxml(self,action = "update"):

        xml_str = ""

        if action == "new" or action == "update":
            self._dirty_all_attr()

        changed = self._changed_attr()

        if changed:
            xml_str = "<bg"

            for a in changed.keys():
                if a == "bg_color":
                    if not (self.bg_color is None):
                        (red,green,blue) = self.bg_color.Get()
                        hexcolor = self.r_h.hexstring(red, green, blue)
                        xml_str += " color='" + hexcolor + "'"
                elif a == "img_path":
                    if not (self.img_path is None):
                        xml_str += " path='" + self.img_path + "'"
                elif a == "type":
                    if not (self.type is None):
                        xml_str += " type='" + str(self.type) + "'"

            xml_str += "/>"

        self._clean_all_attr()
        return xml_str


    def takedom(self,xml_dom):
        type = xml_dom.getAttribute("type")
        color = xml_dom.getAttribute("color")
        path = xml_dom.getAttribute("path")

        # Begin ted's map changes
        if color <> "":
            r,g,b = self.r_h.rgb_tuple(color)
            self.set_color(cmpColour(r,g,b))
        if path <> "":
            dummy = 1
            self.set_image(path,dummy)
        if path <> "":
            self.set_texture(path)
        # End ted's map changes

        if type <> "":
            type = int(type)


        if type == BG_COLOR:
            if color <> "":
                r,g,b = self.r_h.rgb_tuple(color)
                self.set_color(cmpColour(r,g,b))
        elif type == BG_TEXTURE:
            if path <> "":
                self.set_texture(path)
        elif type == BG_IMAGE:
            if path <> "":
                dummy = 1
                self.set_image(path,dummy)

        elif type == BG_NONE:
            self.clear()

        self._clean_attr("type")
        self._clean_attr("bg_color")
        self._clean_attr("img_path")
