# ui-preferences.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc Pref_Init {userDefaults appDefaults} {
    global pref

    set pref(uid) 0
    set pref(userDefaults) $userDefaults
    set pref(appDefaults) $appDefaults
    
    PrefReadFile $appDefaults startup
    if [file exists $userDefaults] {
	PrefReadFile $userDefaults user
    }
}

proc PrefReadFile {basename level} {
    if [catch {option readfile $basename $level} err] {
	puts stderr "Error in $basename: $err"
    }
}

proc PrefVar {item} {lindex $item 0}
proc PrefRes {item} {lindex $item 1}
proc PrefDefault {item} {lindex $item 2}
proc PrefComment {item} {lindex $item 3}
proc PrefHelp {item} {lindex $item 4}

proc Pref_Add {prefs} {
    global pref
    append pref(items) $prefs " "
    foreach item $prefs {
	set varName [PrefVar $item]
	set resName [PrefRes $item]
	set value [PrefValue $varName $resName]
	if {$value == {}} {
	    set default [PrefDefault $item]
	    switch -regexp -- $default {
		^CHOICE {
		    PrefValueSet $varName [lindex $default 1]
		}
		^OFF {
		    PrefValueSet $varName 0
		}
		^ON {
		    PrefValueSet $varName 1
		}
		default {
		    PrefValueSet $varName $default
		}
	    }
	}
    }
}

proc PrefValue {varName res} {
    upvar #0 $varName var
    if [info exists var] {
	return $var
    }
    set var [option get . $res {}]
}

proc PrefValueSet {varName value} {
    upvar #0 $varName var
    set var $value
}

proc Pref_Dialog {} {
    global pref
    if [catch {toplevel .pref}] {
	raise .pref
    } else {
	wm title .pref "Preferences"
	set buttons [frame .pref.but -bd 5]
	pack .pref.but -side top -fill x
	button $buttons.quit -text Dismiss -command {PrefDismiss}
	button $buttons.save -text Save -command {PrefSave}
	button $buttons.reset -text Reset -command {PrefReset; PrefDismiss}
	label $buttons.label -text "Click labels for info on each item"
	pack $buttons.label -side left -fill x
	pack $buttons.quit $buttons.save $buttons.reset -side right -padx 4
	
	frame .pref.b -borderwidth 2 -relief raised
	pack .pref.b -fill both
	set body [frame .pref.b.b -bd 10]
	pack .pref.b.b -fill both

	set maxWidth 0
	foreach item $pref(items) {
	    set len [string length [PrefComment $item]]
	    if {$len > $maxWidth} {
		set maxWidth $len
	    }
	}

	set pref(uid) 0
	foreach item $pref(items) {
	    PrefDialogItem $body $item $maxWidth
	}
    }
}

proc PrefDialogItem {frame item width} {
    global pref
    incr pref(uid)
    set f [frame $frame.p$pref(uid) -borderwidth 2]
    pack $f -fill x
    label $f.label -text [PrefComment $item] -width $width
    bind $f.label <1> [list PrefItemHelp %X %Y [PrefHelp $item]]
    pack $f.label -side left
    set default [PrefDefault $item]
    if {[regexp "^CHOICE " $default]} {
	foreach choice [lreplace $default 0 0] {
	    incr pref(uid)
	    radiobutton $f.c$pref(uid) -text $choice \
		    -variable [PrefVar $item] -value $choice
	    pack $f.c$pref(uid) -side left
	}
    } else {
	if {$default == "OFF" || $default == "ON"} {
	    set varName [PrefVar $item]
	    checkbutton $f.check -variable $varName \
		    -command [list PrefFixupBoolean $f.check $varName]
	    PrefFixupBoolean $f.check $varName
	    pack $f.check -side left
	} else {
	    entry $f.entry -width 10 -relief sunken
	    pack $f.entry -side left -fill x -expand true
	    set pref(entry,[PrefVar $item]) $f.entry
	    set varName [PrefVar $item]
	    $f.entry insert 0 [uplevel #0 [list set $varName]]
	    bind $f.entry <Return> "PrefEntrySet %W $varName"
	}
    }
}

proc PrefFixUpBoolean {check varname} {
    upvar #0 $varname var
    #Update the checkbutton text each time it changes
    if {$var} {
	$check config -text On
    } else {
	$check config -text Off
    }
}

proc PrefEntrySet {entry varName} {
    PrefValueSet $varName [$entry get]
}

proc PrefItemHelp {x y text} {
    catch {destroy .prefitemhelp}
    if {$text == {}} {
	return
    }
    set self [toplevel .prefitemhelp -class Itemhelp]
    wm title $self "Item help"
    wm geometry $self +[expr $x+10]+[expr $y+10]
    wm transient $self .pref
    message $self.msg -text $text -aspect 1500
    pack $self.msg
    bind $self.msg <1> {PrefNukeItemHelp .prefitemhelp}
    .pref.but.label configure -text "Click on pop-up or another label"
}

proc PrefNukeItemHelp {t} {
    .pref.but.label configure -text "Click labels for info on each item"
    destroy $t
}

proc PrefSave {} {
    global pref
    if [catch {
	set old [open $pref(userDefaults) r]
	set oldValues [split [read $old] \n]
	close $old
    }] {
	set oldValues {}
    }
    if [catch {open $pref(userDefaults).new w} out] {
	.pref.but.label configure -text \
		"Cannot save in $pref(userDefaults).new: $out"
	return
    }
    foreach line $oldValues {
	if {$line == \
		"!!! Lines below here automatically added"} {

	    break
	} else {
	    puts $out $line
	}
    }
    puts $out "!!! Lines below here automatically added"
    puts $out "!!! [exec date]"
    puts $out "!!! Do not edit below here"
    foreach item $pref(items) {
	set varName [PrefVar $item]
	set resName [PrefRes $item]
	if [info exists pref(entry,$varName)] {
	    PrefEntrySet $pref(entry,$varName) $varName
	}
	set value [PrefValue $varName $resName]
	puts $out [format "%s\t%s" *${resName}: $value]
    }
    close $out
    set new [glob $pref(userDefaults).new]
    set old [file root $new]
    if [catch {file rename -force $new $old} err] {
	puts stderr "Cannot install $new: $err"
	return
    }
    PrefDismiss
}

proc PrefReset {} {
    global pref
    # Re-read user defaults
    option clear
    PrefReadFile $pref(appDefaults) startup
    PrefReadFile $pref(userDefaults) user
    # Clear variables
    set items $pref(items)
    set pref(items) {}
    foreach item $items {
	uplevel #0 [list unset [PrefVar $item]]
    }
    # Restore values
    Pref_Add $items
}


proc PrefDismiss {} {
    destroy .pref
    catch {destroy .prefitemhelp}
}


