# udp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#provide UDPChannel
import Network


# Open a new UDP channel.  If <i>spec</i> is given in the
# form <i>address</i>/<i>port</i>, that address is used for
# sending and receiving all data. If <i>spec</i> is given in the
# form <i>port</i>, that port is opened for listening.  If
# <i>spec</i> is not given, the channel is bound to an ephemeral port.
UDPChannel public init { {spec ""} {mtu 1024} } {
	$self next $mtu

	$self instvar net_
	set net_ [new Network]
	$net_ loopback 1

	if {$spec == ""} {
		$net_ open 0
	} elseif [regexp {^[0-9]*$} $spec] {
		$net_ open $spec
	} else {
		set spec [split $spec /]
		set len [llength $spec]
		if { $len<2 || $len>3 } {
			$self fatal "invalid spec \"$spec\"."
		}
		set addr [lindex $spec 0]
		set ports [split [lindex $spec 1] :]

		#FIXME
		set ttl 15
		if {$len == 3} {
			set ttl [lindex $spec 2]
		}

		if {[llength $ports] == 1} {
			set port [lindex $ports 0]
			$net_ open $addr $port $ttl
		} else {
			set sport [lindex $ports 0]
			set rport [lindex $ports 1]
			$net_ open $addr $sport $rport $ttl
		}
	}

	$self network $net_
}

#
UDPChannel public destroy {} {
	$self instvar net_
	delete $net_

	$self next
}

# Sets the multicast TTL for all outgoing packets to <i>t</i>.
UDPChannel public ttl {t} {
	$self instvar net_
	$net_ ttl $t
}
